/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlSpecification;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoCadastroId;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.dto.ComunicadoCadastroDTO;
import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import br.com.elotech.tributos.repository.ComunicadoCadastroRepository;
import br.com.elotech.tributos.specs.ComunicadoCadastroSpecifications;
import java.util.Objects;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ComunicadoCadastroService
extends CrudService<ComunicadoCadastro, ComunicadoCadastroId> {
    private final ComunicadoCadastroRepository comunicadoCadastroRepository;
    private final EntityManager em;

    public Page<ComunicadoCadastroDTO> findByRsqlComunicadoCadastro(Long entidade, Long exercicio, Long idComunicado, String search, Pageable pageable) {
        Specification specification = Specification.where((Specification)ComunicadoCadastroSpecifications.comunicadoCadastroIdEntidadeSpecification((Long)entidade)).and(ComunicadoCadastroSpecifications.comunicadoCadastroIdExercicioSpecification((Long)exercicio)).and(ComunicadoCadastroSpecifications.comunicadoCadastroIdIdComunicadoSpecification((Long)idComunicado));
        if (StringUtils.isNotBlank((CharSequence)search)) {
            specification = specification.and((Specification)new RsqlSpecification(this.em, search));
        }
        return this.comunicadoCadastroRepository.findAll(specification, pageable).map(ComunicadoCadastroDTO::from);
    }

    public ComunicadoCadastroDTO cancelaComunicadoCadastro(Long entidade, Long exercicio, Long idComunicado, Long sequencia) {
        ComunicadoId comunicadoIdParam = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        Comunicado comunicadoParam = new Comunicado();
        comunicadoParam.setId(comunicadoIdParam);
        ComunicadoCadastroId comunicadoCadastroIdParam = new ComunicadoCadastroId();
        comunicadoCadastroIdParam.setComunicado(comunicadoParam);
        comunicadoCadastroIdParam.setSequencia(sequencia);
        ComunicadoCadastro comunicadoCadastro = (ComunicadoCadastro)this.comunicadoCadastroRepository.findOne((Object)comunicadoCadastroIdParam);
        if (Objects.isNull(comunicadoCadastro)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a notifica\u00e7\u00e3o com identificador: Entidade %d, Exercicio %d, idComunicado %d e sequencia %d", entidade, exercicio, idComunicado, sequencia));
        }
        if (comunicadoCadastro.getSituacao().equals((Object)SituacaoComunicadoCadastro.CANCELADO)) {
            throw new EloValidationException("Esta notifica\u00e7\u00e3o j\u00e1 est\u00e1 cancelada");
        }
        comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.CANCELADO);
        comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.CANCELADO.getDescricao());
        this.comunicadoCadastroRepository.save((Object)comunicadoCadastro);
        return ComunicadoCadastroDTO.from((ComunicadoCadastro)comunicadoCadastro);
    }

    @Generated
    public ComunicadoCadastroService(ComunicadoCadastroRepository comunicadoCadastroRepository, EntityManager em) {
        this.comunicadoCadastroRepository = comunicadoCadastroRepository;
        this.em = em;
    }
}

