/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.dto.ArquivoUnicoSalvarDTO;
import br.com.elotech.tributos.dto.CadastroImobiliarioLocalizacaoDTO;
import br.com.elotech.tributos.dto.CertidaoDividaAtivaDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoItemPeticaoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoDocumentoDTO;
import br.com.elotech.tributos.dto.documento.peticao.CdaGeracaoPeticaoDTO;
import br.com.elotech.tributos.dto.documento.peticao.GeracaoLotePeticaoDTO;
import br.com.elotech.tributos.exception.CadastroImobiliarioDTOException;
import br.com.elotech.tributos.report.loader.CertidaoDividaAtivaParamLoader;
import br.com.elotech.tributos.repository.CertidaoDividaAtivaRepository;
import br.com.elotech.tributos.service.ArquivoUnicoService;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.CertidaoDividaAtivaHistoricoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoPeticaoService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class CertidaoDividaAtivaService {
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final CertidaoDividaAtivaRepository certidaoDividaAtivaRepository;
    private final CertidaoDividaAtivaParamLoader certidaoDividaAtivaParamLoader;
    private final DocumentoPeticaoService documentoPeticaoService;
    private final DocumentoService documentoService;
    private final ContextService contextService;
    private final AiseRelatorioService aiseRelatorioService;
    private final ArquivoUnicoService arquivoUnicoService;
    private final CertidaoDividaAtivaHistoricoService certidaoDividaAtivaHistoricoService;

    public CertidaoDividaAtivaService(CadastroImobiliarioService cadastroImobiliarioService, CertidaoDividaAtivaRepository certidaoDividaAtivaRepository, CertidaoDividaAtivaParamLoader certidaoDividaAtivaParamLoader, DocumentoPeticaoService documentoPeticaoService, DocumentoService documentoService, ContextService contextService, AiseRelatorioService aiseRelatorioService, ArquivoUnicoService arquivoUnicoService, CertidaoDividaAtivaHistoricoService certidaoDividaAtivaHistoricoService) {
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.certidaoDividaAtivaRepository = certidaoDividaAtivaRepository;
        this.certidaoDividaAtivaParamLoader = certidaoDividaAtivaParamLoader;
        this.documentoPeticaoService = documentoPeticaoService;
        this.documentoService = documentoService;
        this.contextService = contextService;
        this.aiseRelatorioService = aiseRelatorioService;
        this.arquivoUnicoService = arquivoUnicoService;
        this.certidaoDividaAtivaHistoricoService = certidaoDividaAtivaHistoricoService;
    }

    public DocumentoDTO findDocumentosDividaAtiva(Long id) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)id);
        if (Objects.isNull(documento)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Documento de d\u00edvida ativa n\u00e3o encontrado");
        }
        DocumentoDTO documentoDTO = DocumentoDTO.from((Documento)documento);
        if (Optional.ofNullable(documento.getCadastroGeral()).isPresent() && documento.getCadastroGeral().getTipoCadastro().isImobiliario().booleanValue()) {
            CadastroImobiliarioLocalizacaoDTO cadastroImobiliarioLocalizacaoDTO = Optional.ofNullable(this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(documento.getCadastroGeral().getTipoCadastro(), documento.getCadastroGeral().getCadastroGeral())).map(CadastroImobiliarioLocalizacaoDTO::from).orElseThrow(() -> new CadastroImobiliarioDTOException(HttpStatus.NOT_FOUND, "Cadastro Imobili\u00e1rio n\u00e3o encontrado"));
            documentoDTO.setCadastroImobiliarioLocalizacaoDTO(cadastroImobiliarioLocalizacaoDTO);
        }
        documentoDTO.setDocumentoDividaAtivaDTO(documentoDTO.agruparDocumentosDividaAtivaPorParcela(this.contextService.getEntidadePrincipal()));
        return documentoDTO;
    }

    public List<CertidaoDividaAtivaDTO> findByDebitoParcela(DebitoParcelaId parcelaId) {
        return this.certidaoDividaAtivaRepository.findByDebitoParcela(parcelaId);
    }

    public DocumentoDTO cancelarCda(Long id, CancelamentoDocumentoDTO cancelamentoDocumentoDTO) {
        List peticao = this.documentoPeticaoService.findPeticoesVinculadasComCDA(id);
        if (!peticao.isEmpty()) {
            throw new EloValidationException(String.format("J\u00e1 existe uma peti\u00e7\u00e3o %d/%d vinculada com esta Certid\u00e3o de d\u00edvida ativa %d/%d", ((DocumentoItemPeticaoDTO)peticao.get(0)).getDocumento(), ((DocumentoItemPeticaoDTO)peticao.get(0)).getExercicio(), ((DocumentoItemPeticaoDTO)peticao.get(0)).getDocumentoCertidao(), ((DocumentoItemPeticaoDTO)peticao.get(0)).getExercicioCertidao()));
        }
        Documento documento = this.documentoService.cancelarDocumento(id, cancelamentoDocumentoDTO);
        this.certidaoDividaAtivaHistoricoService.salvaHistoricoOperacaoCancelamento(documento, cancelamentoDocumentoDTO.getObservacao());
        return DocumentoDTO.from((Documento)documento);
    }

    public ImprimirRelatorioDTO buildImpressaoCDA(Documento documento) {
        if (Objects.isNull(documento)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Documento de d\u00edvida ativa n\u00e3o encontrado");
        }
        Relatorio relatorio = documento.getDocumentoTipo().getRelatorio();
        if (Objects.isNull(relatorio)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Relat\u00f3rio n\u00e3o encontrado");
        }
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(relatorio.getId().getRelatorio());
        dto.setModulo(relatorio.getId().getModulo());
        dto.setTipoRelatorioFromEnum(relatorio.getId().getTipoRelatorio());
        dto.setFiltro(String.format(" td.Exercicio = %d and td.Documento = %d", documento.getExercicio(), documento.getDocumento()));
        dto.setListParametros(this.certidaoDividaAtivaParamLoader.load(documento.getExercicio()));
        dto.setListVariaveisAmbienteTela(String.format("TabelaCDADebito=%s%n", "tribdocumentoitemdividaativa"));
        dto.setSubReports(this.createSubReportImprimirCDA(dto.getFiltro()));
        return dto;
    }

    public Long salvarArquivoUnico(Long id) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)id);
        ArquivoUnicoSalvarDTO arquivoUnicoSalvarDTO = this.buildSalvarArquivoUnicoCDA(documento);
        Long idArquivoUnico = this.arquivoUnicoService.salvarPDF(arquivoUnicoSalvarDTO);
        documento.setIdArquivoUnico(idArquivoUnico);
        this.documentoService.save((EloEntity)documento, null);
        return idArquivoUnico;
    }

    public ArquivoUnicoSalvarDTO buildSalvarArquivoUnicoCDA(Documento documento) {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.buildImpressaoCDA(documento);
        byte[] relatorio = this.aiseRelatorioService.imprimirRelatorioGenerico(imprimirRelatorioDTO);
        ArquivoUnicoSalvarDTO arquivoUnicoSalvarDTO = new ArquivoUnicoSalvarDTO();
        arquivoUnicoSalvarDTO.setContent(relatorio);
        arquivoUnicoSalvarDTO.setTipoArquivo(TipoArquivoEnum.CERTIDAO_DIVIDA_ATIVA);
        arquivoUnicoSalvarDTO.setDiretorio("/cdas");
        arquivoUnicoSalvarDTO.setFileName("certidao_divida_ativa_" + documento.getId() + ".pdf");
        return arquivoUnicoSalvarDTO;
    }

    private SubReportDTO createSubReportImprimirCDA(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Debitos", filtro), new SubReportItemDTO("S\u00f3cios", filtro), new SubReportItemDTO("Proprietarios", filtro), new SubReportItemDTO("DevedorSolidario", filtro), new SubReportItemDTO("TotalDebitosCDA", filtro.replaceAll("td.", "a.")), new SubReportItemDTO("CertidaoDividaAtivaProprietarios", filtro)}));
        return subReportDTO;
    }

    public Page<DocumentoDTO> getDocumentos(Optional<String> search, Pageable pageable) {
        String searchFilter = String.format("tipoDocumento == %d", TipoDocumentoEnum.CERTIDAO_DIVIDA_ATIVA.getCodigo());
        if (search.isPresent()) {
            searchFilter = searchFilter.concat(" and ").concat(search.get());
        }
        return this.documentoService.getDocumentos(Optional.of(searchFilter), pageable);
    }

    public List<CdaGeracaoPeticaoDTO> findCdaGeracaoPeticao(GeracaoLotePeticaoDTO geracaoLotePeticaoDTO) {
        return this.certidaoDividaAtivaRepository.findCdaGeracaoPeticao(geracaoLotePeticaoDTO, this.contextService.getEntidadePrincipal());
    }
}

