/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.RastreamentoService;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CertidaoDebitosService {
    private final RastreamentoService rastreamentoService;
    private final DocumentoService documentoService;

    public CertidaoDebitosService(RastreamentoService rastreamentoService, DocumentoService documentoService) {
        this.rastreamentoService = rastreamentoService;
        this.documentoService = documentoService;
    }

    public DocumentoDTO geraCertidaoPorContribuinte(@Valid DocumentoGenericoDTO documentoGenericoDTO) {
        documentoGenericoDTO.setPorCadastro(Boolean.FALSE);
        Set rastreamentoCadastroDTOS = this.rastreamentoService.porContribuinte(documentoGenericoDTO.getCodigoPessoa());
        documentoGenericoDTO.setSubTipo(RastreamentoCadastroDTO.getTipoCertidaoDebitos((Set)rastreamentoCadastroDTOS).getValue());
        return this.documentoService.gerar(documentoGenericoDTO, TipoDocumentoEnum.CERTIDAO_CONTRIBUINTE);
    }

    public DocumentoDTO geraCertidaoPorCadastro(@Valid DocumentoGenericoDTO documentoGenericoDTO) {
        Set rastreamentoCadastroDTOS = this.rastreamentoService.porCadastro(documentoGenericoDTO.getIdCadastro());
        documentoGenericoDTO.setSubTipo(RastreamentoCadastroDTO.getTipoCertidaoDebitos((Set)rastreamentoCadastroDTOS).getValue());
        return this.documentoService.gerar(documentoGenericoDTO, TipoDocumentoEnum.CERTIDAO_CADASTRO_MUNICIPAL);
    }
}

