/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CadastroGeralObservacao;
import br.com.elotech.tributos.domain.CadastroGeralObservacaoId;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.repository.CadastroGeralObservacaoRepository;
import java.time.LocalDate;
import org.springframework.stereotype.Service;

@Service
public class CadastroGeralObservacaoService
extends CrudService<CadastroGeralObservacao, CadastroGeralObservacaoId> {
    private final CadastroGeralObservacaoRepository cadastroGeralObservacaoRepository;

    public CadastroGeralObservacaoService(CadastroGeralObservacaoRepository cadastroGeralObservacaoRepository) {
        this.cadastroGeralObservacaoRepository = cadastroGeralObservacaoRepository;
    }

    public CadastroGeralObservacao geraObservacao(CadastroGeral cadastroGeral, String texto, String usuario) {
        CadastroGeralObservacaoId cadastroGeralObservacaoId = CadastroGeralObservacaoId.builder().cadastroGeral(cadastroGeral.getCadastroGeral()).tipoCadastro(cadastroGeral.getTipoCadastro().getValue()).sequencia(this.findLastSequencia(cadastroGeral.getTipoCadastro(), cadastroGeral.getCadastroGeral())).build();
        CadastroGeralObservacao cadastroGeralObservacao = new CadastroGeralObservacao();
        cadastroGeralObservacao.setId(cadastroGeralObservacaoId);
        cadastroGeralObservacao.setData(LocalDate.now());
        cadastroGeralObservacao.setDescricao(texto);
        cadastroGeralObservacao.setUsuario(usuario);
        return cadastroGeralObservacao;
    }

    private Long findLastSequencia(TipoCadastro tipoCadastro, Long cadastroGeral) {
        return this.cadastroGeralObservacaoRepository.findLastSequencia(tipoCadastro.getValue(), cadastroGeral) + 1L;
    }
}

