/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CadastroGeralIsencao;
import br.com.elotech.tributos.repository.CadastroGeralIsencaoRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class CadastroGeralIsencaoService
extends CrudService<CadastroGeralIsencao, Long> {
    private final CadastroGeralIsencaoRepository cadastroGeralIsencaoRepository;
    private final CadastroGeralService cadastroGeralService;

    public CadastroGeralIsencaoService(CadastroGeralIsencaoRepository cadastroGeralIsencaoRepository, CadastroGeralService cadastroGeralService) {
        this.cadastroGeralIsencaoRepository = cadastroGeralIsencaoRepository;
        this.cadastroGeralService = cadastroGeralService;
    }

    public List<CadastroGeralIsencao> findByCadastroGeralId(Long id, Sort sort) {
        return this.cadastroGeralIsencaoRepository.findByCadastroGeralId(id, sort);
    }

    public Optional<CadastroGeralIsencao> findByCadastroGeralIdAndIsencaoId(Long id, Long isencao) {
        return this.cadastroGeralIsencaoRepository.findByCadastroGeralIdAndIsencaoId(id, isencao);
    }

    public CadastroGeralIsencao create(CadastroGeralIsencao isencao) {
        CadastroGeral cadastroGeral = this.getAndValidateCadastro(isencao.getCadastroGeral());
        isencao.setCadastroGeral(cadastroGeral);
        return (CadastroGeralIsencao)this.save((EloEntity)isencao, null);
    }

    private CadastroGeral getAndValidateCadastro(CadastroGeral cadastro) {
        if (Objects.isNull(cadastro)) {
            throw new EloValidationException("N\u0101o \u00e9 poss\u00edvel salvar isen\u00e7\u0101o sem cadastro.");
        }
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findById((Serializable)cadastro.getId()).orElseThrow(() -> new EloValidationException(String.format("N\u0101o foi poss\u00edvel encontrar cadastro com o id %d.", cadastro.getId())));
        if (cadastroGeral.getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O cadastro %d - %d se encontra em exclus\u0101o l\u00f3gica", cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral()));
        }
        return cadastroGeral;
    }

    public CadastroGeralIsencao update(Long idIsencao, CadastroGeralIsencao isencaoAtualizada) {
        CadastroGeralIsencao isencao = (CadastroGeralIsencao)this.findById((Serializable)idIsencao).orElseThrow(() -> new EloValidationException(String.format("N\u0101o foi poss\u00edvel encontrar cadastro geral isen\u00e7\u0101o com o id %d.", idIsencao)));
        if (isencao.getCadastroGeral().getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O cadastro geral %d - %d se encontra em exclus\u0101o l\u00f3gica.", isencao.getCadastroGeral().getTipoCadastro().getValue(), isencao.getCadastroGeral().getCadastroGeral()));
        }
        isencao.setAnoIsencao(isencaoAtualizada.getAnoIsencao());
        isencao.setFimIsencao(isencaoAtualizada.getFimIsencao());
        isencao.setMotivoIsencao(isencaoAtualizada.getMotivoIsencao());
        return (CadastroGeralIsencao)this.save((EloEntity)isencao, null);
    }
}

