/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.TipoExtratoDebitoEnum;
import br.com.elotech.tributos.domain.atendimento.Atendimento;
import br.com.elotech.tributos.domain.atendimento.AtendimentoHistorico;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.dto.AdvancedSearchItemDTO;
import br.com.elotech.tributos.dto.AdvancedSearchParamsDTO;
import br.com.elotech.tributos.dto.AtendimentoPessoaDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.EnderecoCadastroGeralDTO;
import br.com.elotech.tributos.dto.ExtratoDebitoDTO;
import br.com.elotech.tributos.dto.FiltroExtratoDebitoDTO;
import br.com.elotech.tributos.dto.SelectedFacetDTO;
import br.com.elotech.tributos.dto.TotalExtratoDebitoDTO;
import br.com.elotech.tributos.dto.ValueBlockDashDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoChartDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoHistoricoDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoInformacaoDashDebitoDTO;
import br.com.elotech.tributos.exception.AtendimentoException;
import br.com.elotech.tributos.hibernatesearch.domain.HibernateSearchParams;
import br.com.elotech.tributos.hibernatesearch.facet.FacetCadastroGeral;
import br.com.elotech.tributos.report.loader.ExtratoDebitoParamLoader;
import br.com.elotech.tributos.repository.ProprietarioRepository;
import br.com.elotech.tributos.repository.atendimento.AtendimentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.AtendimentoHistoricoService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.HibernateSearchService;
import br.com.elotech.tributos.service.ValidaEmissaoBoletoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class AtendimentoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtendimentoService.class);
    private final AtendimentoRepository atendimentoRepository;
    private final ProprietarioRepository proprietarioRepository;
    private final FormaPagamentoService formaPagamentoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final AtendimentoHistoricoService atendimentoHistoricoService;
    private final ValidaEmissaoBoletoService validaEmissaoBoletoService;
    private final DebitoEmAbertoService debitoEmAbertoService;
    private final CadastroGeralService cadastroGeralService;
    private final HibernateSearchService hibernateSearchService;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ExtratoDebitoParamLoader extratoDebitoParamLoader;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;

    private String mountFiltro(String columnName, Long tipoCadastro, Long cadastroGeral) {
        return String.format(" %s.TIPOCADASTRO = %d and %s.CADASTROGERAL = %d ", columnName, tipoCadastro, columnName, cadastroGeral);
    }

    public List<DebitoEmAbertoDTO> findDebitosEmAberto(Long tipoCadastro, Long cadastroGeral) {
        FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        log.trace("Buscou forma da pagamento padr\u00e3o");
        List debitos = this.debitoEmAbertoService.loadDebitoEmAberto(this.mountFiltro("TRIBDEBITO", tipoCadastro, cadastroGeral), Boolean.TRUE);
        log.trace("Carregou d\u00e9bitos");
        List debitosComAcrescimo = this.calculoAcrescimoService.calculaAcrescimos(debitos, formaPagamentoPadrao.getId());
        log.trace("Calculou acr\u00e9scimos");
        this.validaEmissaoBoletoService.podeEmitirBoleto(debitosComAcrescimo, Boolean.valueOf(false));
        log.trace("Validou emiss\u00e3o de boleto");
        return DebitoEmAbertoDTO.agruparPorParcela((List)debitosComAcrescimo);
    }

    private List<DebitoEmAbertoDTO> findTotalDebitosEmAberto(Long tipoCadastro, Long cadastroGeral) {
        FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        List debitos = this.calculoAcrescimoService.calculaAcrescimos(this.debitoEmAbertoService.loadDebitoEmAberto(this.mountFiltro("TRIBDEBITO", tipoCadastro, cadastroGeral), Boolean.TRUE), formaPagamentoPadrao.getId());
        return DebitoEmAbertoDTO.agruparPorParcela((List)debitos);
    }

    public Map<TipoExtratoDebitoEnum, TotalExtratoDebitoDTO> findTotaisExtratoDebitos(Long tipoCadastro, Long cadastroGeral) {
        FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        log.trace("Buscou forma da pagamento padr\u00e3o");
        List extratoDebitos = this.debitoEmAbertoService.loadExtratoDebitosByIdCadastro(this.mountFiltro("TD", tipoCadastro, cadastroGeral));
        log.trace("Carregou extrato de d\u00e9bitos");
        List debitosComAcrescimo = this.calculoAcrescimoService.calculaAcrescimos(extratoDebitos, formaPagamentoPadrao.getId());
        log.trace("Calculou acr\u00e9scimos");
        return ExtratoDebitoDTO.gerarTotalizador((List)debitosComAcrescimo);
    }

    public Page<ExtratoDebitoDTO> findExtratoDebitos(FiltroExtratoDebitoDTO filtro, Pageable pageable) {
        Sort.Order order;
        List parcelasAgrupadas = this.getExtratoAgrupadoParcela(filtro);
        Optional<String> sort = pageable.getSort().stream().findFirst().map(Sort.Order::getProperty);
        Comparator comparator = this.getComparing(pageable);
        if (sort.isPresent() && (order = pageable.getSort().getOrderFor(sort.get())).getDirection().isDescending()) {
            comparator = comparator.reversed();
        }
        List parcelasAgrupadasPaged = parcelasAgrupadas.stream().sorted(comparator).skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return new PageImpl(parcelasAgrupadasPaged, pageable, (long)parcelasAgrupadas.size());
    }

    private Comparator<ExtratoDebitoDTO> getComparing(Pageable pageable) {
        Optional<String> sort = pageable.getSort().stream().findFirst().map(Sort.Order::getProperty);
        if (sort.isPresent()) {
            if (sort.get().equals("parcela")) {
                return Comparator.comparing(CalculaAcrescimoBaseDTO::getParcela);
            }
            if (sort.get().equals("situacao")) {
                return Comparator.comparing(CalculaAcrescimoBaseDTO::getSituacao);
            }
            if (sort.get().equals("vencimento")) {
                return Comparator.comparing(CalculaAcrescimoBaseDTO::getDataVencimento);
            }
            if (sort.get().equals("movimento")) {
                return Comparator.comparing(ExtratoDebitoDTO::getDataMovimento);
            }
            if (sort.get().equals("valorTotal")) {
                return Comparator.comparing(CalculaAcrescimoBaseDTO::getValorTotal);
            }
            if (sort.get().equals("valorPago")) {
                return Comparator.comparing(ExtratoDebitoDTO::getValorPago);
            }
            if (sort.get().equals("pagamento")) {
                return Comparator.comparing(ExtratoDebitoDTO::getPagamento);
            }
        }
        return Comparator.comparing(CalculaAcrescimoBaseDTO::getExercicio).thenComparing(CalculaAcrescimoBaseDTO::getDivida);
    }

    private List<ExtratoDebitoDTO> getExtratoAgrupadoParcela(FiltroExtratoDebitoDTO filtro) {
        FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        List extratoDebitos = this.debitoEmAbertoService.loadExtratoDebitosByFiltro(filtro);
        List debitos = this.calculoAcrescimoService.calculaAcrescimos(extratoDebitos, formaPagamentoPadrao.getId());
        return ExtratoDebitoDTO.agruparPorParcela((List)debitos);
    }

    public Page<AtendimentoPessoaDTO> searchPessoa(String search, Pageable pageable) {
        StringBuilder searchBuilder = new StringBuilder().append("%").append(search.toUpperCase()).append("%");
        return this.proprietarioRepository.findPessoa(searchBuilder.toString(), pageable);
    }

    public AtendimentoInformacaoDashDebitoDTO getValorTotalDebito(Long tipoCadastro, Long cadastroGeral) {
        List valoresDebitos = this.findTotalDebitosEmAberto(tipoCadastro, cadastroGeral);
        BigDecimal valorTotal = valoresDebitos.stream().map(v -> v.getValorPrincipal().add(v.getValorJuros()).add(v.getValorMulta()).add(v.getValorCorrecao())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valorTotalDesconto = valoresDebitos.stream().map(v -> v.getValorDescontoPrincipal().add(v.getValorDescontoJuros()).add(v.getValorDescontoMulta()).add(v.getValorDescontoCorrecao())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valorTotalDebito = valorTotal.subtract(valorTotalDesconto).setScale((int)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS, 4);
        Boolean isVencido = valoresDebitos.stream().anyMatch(DebitoEmAbertoDTO::getVencido);
        return new AtendimentoInformacaoDashDebitoDTO(valorTotalDebito, isVencido);
    }

    public AtendimentoInformacaoDashDebitoDTO getValorTotalParcelamentos(Long idCadastro) {
        List valoresDebitosParcelamento = this.atendimentoRepository.findTotalParcelamentosEmAberto(idCadastro);
        BigDecimal valorTotalParcelamentos = valoresDebitosParcelamento.stream().map(CalculaAcrescimoBaseDTO::getValorPrincipal).reduce(BigDecimal.ZERO, BigDecimal::add);
        Boolean isVencido = valoresDebitosParcelamento.stream().anyMatch(DebitoEmAbertoDTO::getVencido);
        return new AtendimentoInformacaoDashDebitoDTO(valorTotalParcelamentos, isVencido);
    }

    public void finalizarAtendimento(Long idAtendimento) {
        Atendimento atendimento = (Atendimento)this.atendimentoRepository.findById((Object)idAtendimento).orElseThrow(() -> new AtendimentoException(HttpStatus.NOT_FOUND, String.format("Atendimento %s n\u00e3o encontrado", idAtendimento)));
        if (atendimento.getHorarioFim() != null) {
            throw new AtendimentoException(HttpStatus.BAD_REQUEST, "N\u00e3o \u00e9 poss\u00edvel finalizar um atendimento com situa\u00e7\u00e3o j\u00e1 finalizada");
        }
        atendimento.setHorarioFim(LocalDateTime.now());
        this.atendimentoRepository.save((Object)atendimento);
        log.info("Atendimento {} finalizado as {}", (Object)idAtendimento, (Object)atendimento.getHorarioFim());
    }

    public AtendimentoDTO save(AtendimentoDTO atendimentoDTO) {
        UUID userIdCurrent = this.getUsuarioIdCurrent();
        Optional loadAtendimentoUser = this.loadAtendimentoUser(userIdCurrent);
        if (loadAtendimentoUser.isPresent()) {
            log.error("Usu\u00e1rio {} j\u00e1 possui atendimento aberto", (Object)userIdCurrent);
            throw new AtendimentoException(HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o pode assumir mais um atendimento at\u00e9 finalizar os antigos");
        }
        if (atendimentoDTO.getId() == null) {
            atendimentoDTO.setHorarioInicio(LocalDateTime.now());
            atendimentoDTO.setAtendente(userIdCurrent);
            log.info("Atendimento iniciado as {} por {}", (Object)atendimentoDTO.getHorarioInicio(), (Object)userIdCurrent);
        }
        CadastroGeral cadastroGeral = this.getCadastroGeralById(atendimentoDTO.getCadastroGeral().getIdCadastro());
        Atendimento atendimento = atendimentoDTO.toEntity(cadastroGeral);
        Atendimento saved = (Atendimento)this.atendimentoRepository.save((Object)atendimento);
        this.atendimentoHistoricoService.save(new AtendimentoHistorico(saved));
        return AtendimentoDTO.from((Atendimento)saved);
    }

    public Boolean exists(Long idAtendimento) {
        return this.atendimentoRepository.existsById((Object)idAtendimento);
    }

    public Optional<Atendimento> findOne(Long idAtendimento) {
        return this.atendimentoRepository.findById((Object)idAtendimento);
    }

    public Atendimento trocaCadastro(Long idAtendimento, Long idCadastro) {
        log.info("Trocando cadastro geral do atendimento {}...", (Object)idAtendimento);
        Atendimento atendimentoFound = (Atendimento)this.atendimentoRepository.findById((Object)idAtendimento).orElseThrow(() -> new AtendimentoException(HttpStatus.NOT_FOUND, String.format("Atendimento %s n\u00e3o encontrado", idAtendimento)));
        CadastroGeral cadastroGeral = this.getCadastroGeralById(idCadastro);
        log.info("Trocado cadastro geral do {} para {} do atendimento {}", new Object[]{atendimentoFound.getCadastroGeral().getId(), idCadastro, idAtendimento});
        atendimentoFound.setCadastroGeral(cadastroGeral);
        Atendimento saved = (Atendimento)this.atendimentoRepository.save((Object)atendimentoFound);
        this.atendimentoHistoricoService.save(new AtendimentoHistorico(saved));
        return saved;
    }

    private CadastroGeral getCadastroGeralById(Long idCadastro) {
        return (CadastroGeral)this.cadastroGeralService.findById((Serializable)idCadastro).orElseThrow(() -> new AtendimentoException(HttpStatus.NOT_FOUND, String.format("Cadastro Geral %s n\u00e3o encontrado", idCadastro)));
    }

    public List<AtendimentoHistoricoDTO> loadHistoricos(Long cadastroGeral) {
        return this.atendimentoHistoricoService.findByAtendimentoId(cadastroGeral);
    }

    public Optional<AtendimentoDTO> loadAtendimentoUser(UUID userId) {
        return this.atendimentoRepository.findAtendimentoEmAbertoByUsuario(userId).stream().sorted(Comparator.comparing(Atendimento::getHorarioInicio)).findFirst().map(AtendimentoDTO::from);
    }

    private UUID getUsuarioIdCurrent() {
        UUID userIdCurrent = SecurityUtils.getUserId();
        if (userIdCurrent == null) {
            throw new AtendimentoException(HttpStatus.BAD_REQUEST, "N\u00e3o foi encontrado o id do usu\u00e1rio");
        }
        return userIdCurrent;
    }

    public List<AtendimentoChartDTO> findAtendimentosNosUltimosDias() {
        LocalDate now = LocalDate.now();
        LocalDateTime inicio = now.minusDays(15L).atStartOfDay();
        LocalDateTime fim = LocalDateTime.of(now, LocalTime.MAX);
        return this.atendimentoRepository.findAtendimentosNoPeriodo(inicio, fim);
    }

    public ValueBlockDashDTO getTempoMedioAtendimento() {
        return new ValueBlockDashDTO(this.atendimentoRepository.getTempoMedioAtendimento());
    }

    public CadastroGeralSearchDTO searchCadastros(CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        List<String> searchFields = Arrays.asList("cep", "pessoa.nome", "pessoa.cnpjCpf", "proprietarios.pessoa.nome", "proprietarios.pessoa.cnpjCpf", "enderecoFormatado");
        HibernateSearchParams hibernateSearchParams = new HibernateSearchParams(this.cadastroGeralService.getEm(), this.hibernateSearchService.getTipoCadastroByFacets(searchParams.getFacets()), pageable, searchParams.getSearch(), searchFields, Collections.singletonList(FacetCadastroGeral.TIPO_CADASTRO));
        Query query = hibernateSearchParams.getQueryBuilder().bool().should((Query)new BoostQuery(hibernateSearchParams.createQueryWithSpecificField("cadastroGeral", searchParams.getSearch()), 1.5f)).should(hibernateSearchParams.createFuzzyQuery()).createQuery();
        FullTextQuery fullTextQuery = this.hibernateSearchService.searchEntities(hibernateSearchParams, query, searchParams.getFacets());
        return this.geraCadastroGeralSearchDTO(fullTextQuery, hibernateSearchParams, searchParams.getFacets());
    }

    public CadastroGeralSearchDTO advancedSearchCadastros(AdvancedSearchParamsDTO searchParams, Pageable pageable) {
        HibernateSearchParams hibernateSearchParams = new HibernateSearchParams(this.cadastroGeralService.getEm(), this.hibernateSearchService.getTipoCadastroByFacets(searchParams.getFacets()), pageable, "", searchParams.getFields().stream().map(AdvancedSearchItemDTO::getName).collect(Collectors.toList()), Collections.singletonList(FacetCadastroGeral.TIPO_CADASTRO));
        BooleanJunction bool = hibernateSearchParams.getQueryBuilder().bool();
        searchParams.getFields().forEach(item -> bool.must(hibernateSearchParams.createQueryWithSpecificField(item.getName(), item.getValue())));
        Query query = bool.createQuery();
        FullTextQuery fullTextQuery = this.hibernateSearchService.searchEntities(hibernateSearchParams, query, new ArrayList());
        return this.geraCadastroGeralSearchDTO(fullTextQuery, hibernateSearchParams, new ArrayList());
    }

    public CadastroGeralSearchDTO searchCadastrosByPessoa(Long idPessoa, Pageable pageable, List<SelectedFacetDTO> facets) {
        List<String> searchFields = Arrays.asList("pessoa.idPessoa", "proprietarios.pessoa.idPessoa");
        HibernateSearchParams hibernateSearchQueryFields = new HibernateSearchParams(this.cadastroGeralService.getEm(), CadastroGeral.class, pageable, idPessoa.toString(), searchFields, Collections.singletonList(FacetCadastroGeral.TIPO_CADASTRO));
        Query query = hibernateSearchQueryFields.createQueryFromSearchFields();
        FullTextQuery fullTextQuery = this.hibernateSearchService.searchEntities(hibernateSearchQueryFields, query, facets);
        return this.geraCadastroGeralSearchDTO(fullTextQuery, hibernateSearchQueryFields, facets);
    }

    public CadastroGeralSearchDTO searchCadastrosByPessoaAndCadastroOrEndereco(Long idPessoa, String search, Pageable pageable, List<SelectedFacetDTO> facets) {
        if (StringUtils.isBlank((CharSequence)search)) {
            return this.searchCadastrosByPessoa(idPessoa, pageable, facets);
        }
        List<String> searchFields = Arrays.asList("cadastroGeral", "enderecoFormatado");
        HibernateSearchParams hibernateSearchQueryFields = new HibernateSearchParams(this.cadastroGeralService.getEm(), CadastroGeral.class, pageable, search, searchFields, Collections.singletonList(FacetCadastroGeral.TIPO_CADASTRO));
        List<String> searchFieldsPessoa = Arrays.asList("pessoa.idPessoa", "proprietarios.pessoa.idPessoa");
        HibernateSearchParams hibernateSearchQueryFieldsPessoa = new HibernateSearchParams(this.cadastroGeralService.getEm(), CadastroGeral.class, pageable, idPessoa.toString(), searchFieldsPessoa, Collections.singletonList(FacetCadastroGeral.TIPO_CADASTRO));
        Query query = hibernateSearchQueryFields.getQueryBuilder().bool().must(hibernateSearchQueryFields.createQueryFromSearchFields()).must(hibernateSearchQueryFieldsPessoa.createQueryFromSearchFields()).createQuery();
        FullTextQuery fullTextQuery = this.hibernateSearchService.searchEntities(hibernateSearchQueryFields, query, facets);
        return this.geraCadastroGeralSearchDTO(fullTextQuery, hibernateSearchQueryFields, facets);
    }

    private CadastroGeralSearchDTO geraCadastroGeralSearchDTO(FullTextQuery fullTextQuery, HibernateSearchParams hibernateSearchParams, List<SelectedFacetDTO> selectedFacetsDTO) {
        CadastroGeralSearchDTO dto = new CadastroGeralSearchDTO();
        dto.setFacets(this.hibernateSearchService.getFacetsDisponiveis(fullTextQuery.getFacetManager(), hibernateSearchParams.getFacets(), selectedFacetsDTO));
        List enderecosCadastroGeralDTO = fullTextQuery.getResultList().stream().map(cadastroGeral -> {
            EnderecoCadastroGeralDTO enderecoCadastroGeralDTO = cadastroGeral.toEnderecoCadastroGeralDTO();
            enderecoCadastroGeralDTO.setVencido(this.cadastroGeralService.hasDebitoVencido(enderecoCadastroGeralDTO.getIdCadastro()));
            return enderecoCadastroGeralDTO;
        }).collect(Collectors.toList());
        dto.setCadastros((Page)new PageImpl(enderecosCadastroGeralDTO, hibernateSearchParams.getPageable(), (long)fullTextQuery.getResultSize()));
        return dto;
    }

    public byte[] imprimirExtratoDebitos(FiltroExtratoDebitoDTO filtro) {
        if (filtro.getTodosCadastros().booleanValue()) {
            filtro.getIdsCadastro().addAll(this.cadastroGeralService.findCadastrosPessoa((Long)filtro.getIdsCadastro().get(0)));
        }
        List parcelasAgrupadas = this.getExtratoAgrupadoParcela(filtro);
        ConfiguracaoInscricaoCadastral configuracaoInscricaoCadastral = this.configuracaoInscricaoCadastralService.getConfiguracao();
        parcelasAgrupadas.forEach(parcela -> parcela.setInscricaoCadastralComMascara(configuracaoInscricaoCadastral.formatarInscricaoCadastral(parcela.getQuadricula(), parcela.getDistrito(), parcela.getSetor(), parcela.getQuadra(), parcela.getLoteInscricaoCadastral(), parcela.getUnidade())));
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)parcelasAgrupadas, ExtratoDebitoDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.extratoDebitoParamLoader).build();
        return EloReportFactory.jasper().reportFile(this.reportFileResolverFactory.fromFile("extrato-debitos.jrxml")).setReportDatasource(datasource).build().exportToPdf();
    }

    @Generated
    public AtendimentoService(AtendimentoRepository atendimentoRepository, ProprietarioRepository proprietarioRepository, FormaPagamentoService formaPagamentoService, CalculoAcrescimoService calculoAcrescimoService, AtendimentoHistoricoService atendimentoHistoricoService, ValidaEmissaoBoletoService validaEmissaoBoletoService, DebitoEmAbertoService debitoEmAbertoService, CadastroGeralService cadastroGeralService, HibernateSearchService hibernateSearchService, ReportFileResolverFactory reportFileResolverFactory, ExtratoDebitoParamLoader extratoDebitoParamLoader, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService) {
        this.atendimentoRepository = atendimentoRepository;
        this.proprietarioRepository = proprietarioRepository;
        this.formaPagamentoService = formaPagamentoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.atendimentoHistoricoService = atendimentoHistoricoService;
        this.validaEmissaoBoletoService = validaEmissaoBoletoService;
        this.debitoEmAbertoService = debitoEmAbertoService;
        this.cadastroGeralService = cadastroGeralService;
        this.hibernateSearchService = hibernateSearchService;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.extratoDebitoParamLoader = extratoDebitoParamLoader;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
    }
}

