/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaogeomais.ProprietarioGeomaisDTO;
import br.com.elotech.tributos.service.ProprietarioService;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/proprietario"})
public class ProprietarioGeomaisResource {
    private final ProprietarioService proprietarioService;

    public ProprietarioGeomaisResource(ProprietarioService proprietarioService) {
        this.proprietarioService = proprietarioService;
    }

    @GetMapping
    public ResponseEntity<Page<ProprietarioGeomaisDTO>> findAll(Pageable page) {
        Page proprietarios = this.proprietarioService.findAll(page).map(ProprietarioGeomaisDTO::from);
        return ResponseEntity.ok((Object)proprietarios);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ProprietarioGeomaisDTO> findById(@PathVariable Long id) {
        ProprietarioGeomaisDTO proprietarioGeomaisDTO = this.proprietarioService.findById((Serializable)id).map(ProprietarioGeomaisDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Propriet\u00e1rio com o id '%d'.", id)));
        return ResponseEntity.ok((Object)proprietarioGeomaisDTO);
    }
}

