/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.dto.integracaogeomais.LoteamentoGeomaisDTO;
import br.com.elotech.tributos.service.LoteamentoService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/loteamento"})
public class LoteamentoGeomaisResource {
    private final LoteamentoService loteamentoService;

    public LoteamentoGeomaisResource(LoteamentoService loteamentoService) {
        this.loteamentoService = loteamentoService;
    }

    @GetMapping
    public ResponseEntity<Page<LoteamentoGeomaisDTO>> findAll(Pageable page) {
        Page loteamentos = this.loteamentoService.findAll(page).map(LoteamentoGeomaisDTO::from);
        return ResponseEntity.ok((Object)loteamentos);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<LoteamentoGeomaisDTO> findByLoteamento(@PathVariable Long id) {
        return ResponseEntity.ok((Object)LoteamentoGeomaisDTO.from((Loteamento)this.loteamentoService.findByLoteamento(id)));
    }
}

