/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaogeomais.BairroGeomaisDTO;
import br.com.elotech.tributos.service.BairroService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/bairro"})
public class BairroGeomaisResource {
    private final BairroService bairroService;

    public BairroGeomaisResource(BairroService bairroService) {
        this.bairroService = bairroService;
    }

    @GetMapping
    public ResponseEntity<Page<BairroGeomaisDTO>> findAllByCidadeEntidadePrincipal(Pageable page) {
        Page bairros = this.bairroService.findAllByCidadeEntidadePrincipal(page).map(BairroGeomaisDTO::from);
        return ResponseEntity.ok((Object)bairros);
    }

    @GetMapping(value={"/{codigo}"})
    public ResponseEntity<BairroGeomaisDTO> findByBairroAndCidadeEntidadePrincipal(@PathVariable Long codigo) {
        BairroGeomaisDTO bairroDTO = this.bairroService.findByBairroAndCidadeEntidadePrincipal(codigo).map(BairroGeomaisDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Bairro com o c\u00f3digo '%d'.", codigo)));
        return ResponseEntity.ok((Object)bairroDTO);
    }
}

