/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaocontabil;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonial;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonialPorTipoMovimentoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.TotalizadorIntegracaoPatrimonialDTO;
import br.com.elotech.tributos.service.integracaocontabil.IntegracaoPatrimonialService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracao-patrimonial"})
public class IntegracaoPatrimonialResource
extends ReadOnlyResource<IntegracaoPatrimonial, Long> {
    private final IntegracaoPatrimonialService integracaoPatrimonialService;

    public IntegracaoPatrimonialResource(IntegracaoPatrimonialService integracaoPatrimonialService) {
        this.integracaoPatrimonialService = integracaoPatrimonialService;
    }

    @GetMapping(value={"/{id}/totais-tipo-movimento"})
    public ResponseEntity<List<IntegracaoPatrimonialPorTipoMovimentoDTO>> findTotaisPorTipoMovimentoAndId(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.integracaoPatrimonialService.findTotaisPorTipoMovimentoAndId(id));
    }

    @GetMapping(value={"/total-search"})
    public ResponseEntity<TotalizadorIntegracaoPatrimonialDTO> getTotalSearch(@RequestParam(value="search", required=false) String search) {
        return ResponseEntity.ok((Object)this.integracaoPatrimonialService.getTotalSearch(search));
    }
}

