/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.cancelamento;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoPk;
import br.com.elotech.tributos.dto.CancelamentoDebitoDTO;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.TributoDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoParcelasFormDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoTributosFormDTO;
import br.com.elotech.tributos.params.DebitoFilterParams;
import br.com.elotech.tributos.params.DebitoTributosPorcentagemParams;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.repository.query.Param;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cancelamentos-debito"})
public class CancelamentoDebitoResource
extends ReadOnlyResource<CancelamentoDebito, CancelamentoDebitoPk> {
    private final CancelamentoDebitoService cancelamentoDebitoService;
    private final DebitoParcelaTributoService debitoParcelasTributoService;

    public CancelamentoDebitoResource(CancelamentoDebitoService cancelamentoDebitoService, DebitoParcelaTributoService debitoParcelasTributoService) {
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.debitoParcelasTributoService = debitoParcelasTributoService;
    }

    @GetMapping(value={"/pk/{entidade}/{exercicio}/{id}"})
    public ResponseEntity<CancelamentoDebitoDTO> findOne(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long id) {
        CancelamentoDebito cancelamentoDebito = (CancelamentoDebito)this.cancelamentoDebitoService.findOne((Serializable)new CancelamentoDebitoPk(entidade, exercicio, id));
        return ResponseEntity.ok((Object)CancelamentoDebitoDTO.from((CancelamentoDebito)cancelamentoDebito));
    }

    @PostMapping(value={"/por-parcela"})
    public ResponseEntity<CancelamentoDebito> cancelamentoDebitoPorParcela(@RequestBody @Valid CancelamentoParcelasFormDTO cancelamento) {
        return ResponseEntity.ok((Object)this.cancelamentoDebitoService.cancelamentoDebitoPorParcela(cancelamento));
    }

    @PostMapping(value={"/por-tributo"})
    public ResponseEntity<CancelamentoDebito> cancelamentoDebitoPorTributo(@RequestBody @Valid CancelamentoTributosFormDTO cancelamento) {
        return ResponseEntity.ok((Object)this.cancelamentoDebitoService.cancelamentoDebitoPorTributo(cancelamento));
    }

    @GetMapping(value={"/por-parcela/parcelas"}, params={"entidade", "exercicio", "tipoCadastro", "cadastroGeral", "situacaoLegal"})
    public ResponseEntity<List<CancelamentoDebitoTributoDTO>> findByDebitoAndAberto(DebitoFilterParams debito, @Param(value="situacaoLegal") Integer situacaoLegal) {
        return ResponseEntity.ok((Object)this.debitoParcelasTributoService.findByDebitoAndAberto(debito, situacaoLegal));
    }

    @GetMapping(value={"/por-tributo/tributos"}, params={"entidade", "exercicio", "tipoCadastro", "cadastroGeral", "situacaoLegal"})
    public ResponseEntity<List<TributoDTO>> getDebitoTributoDescricao(DebitoFilterParams params, @Param(value="situacaoLegal") Integer situacaoLegal) {
        return ResponseEntity.ok((Object)this.debitoParcelasTributoService.getDebitoTributoDescricao(params, situacaoLegal));
    }

    @PostMapping(value={"/por-tributo/parcelas"})
    public ResponseEntity<List<CancelamentoDebitoTributoDTO>> getDebitoParcelaTributoCancelamento(@RequestBody @Valid DebitoTributosPorcentagemParams params) {
        return ResponseEntity.ok((Object)this.debitoParcelasTributoService.getDebitoParcelaTributoCancelamento(params));
    }
}

