/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.dto.ParametroPixDTO;
import br.com.elotech.tributos.service.ParametroPixService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/parametros-pix"})
public class ParametroPixResource {
    private final ParametroPixService parametroPixService;

    @GetMapping(value={"/{entidade}"})
    public ResponseEntity<ParametroPix> findOne(@PathVariable(name="entidade") Long idEntidade) {
        return ResponseEntity.ok((Object)((ParametroPix)this.parametroPixService.findOne((Serializable)idEntidade)));
    }

    @PostMapping
    public ResponseEntity<ParametroPix> save(ParametroPixDTO parametroPixDTO, @RequestParam(required=false) MultipartFile certificado) throws IOException {
        ParametroPix parametro = this.parametroPixService.findById((Serializable)parametroPixDTO.getEntidade()).orElse(new ParametroPix());
        parametro.setEntidade(parametroPixDTO.getEntidade());
        parametro.setSenhaCertificadoItau(parametroPixDTO.getSenhaCertificadoItau());
        if (Objects.nonNull(certificado) || !StringUtils.equals((String)parametro.getNomeArquivoCertificadoItau(), (String)parametroPixDTO.getNomeArquivoCertificadoItau())) {
            parametro.setCertificadoItau(Objects.nonNull(certificado) ? certificado.getBytes() : null);
            parametro.setNomeArquivoCertificadoItau(parametroPixDTO.getNomeArquivoCertificadoItau());
        }
        return ResponseEntity.ok((Object)this.parametroPixService.save(parametro));
    }

    @Generated
    public ParametroPixResource(ParametroPixService parametroPixService) {
        this.parametroPixService = parametroPixService;
    }
}

