/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoDebitoId;
import br.com.elotech.tributos.dto.pagamento.PagamentoDebitoPorParcelaDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoDebitoPorTributoDTO;
import br.com.elotech.tributos.service.PagamentoDebitoService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pagamentos-debito"})
public class PagamentoDebitoResource
extends CrudResource<PagamentoDebito, PagamentoDebitoId> {
    private final PagamentoDebitoService pagamentoDebitoService;

    public PagamentoDebitoResource(PagamentoDebitoService pagamentoDebitoService) {
        this.pagamentoDebitoService = pagamentoDebitoService;
    }

    @GetMapping(value={"/por-tributo/{entidade}/{exercicioPagamento}/{pagamento}"})
    public ResponseEntity<List<PagamentoDebitoPorTributoDTO>> getPagamentoDebitoPorTributo(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicioPagamento") Long exercicioPagamento, @PathVariable(value="pagamento") Long pagamento) {
        return ResponseEntity.ok((Object)this.pagamentoDebitoService.findPagamentoDebitoPorTributoByPagamento(entidade, exercicioPagamento, pagamento));
    }

    @GetMapping(value={"/por-parcela/{entidade}/{exercicioPagamento}/{pagamento}"})
    public ResponseEntity<List<PagamentoDebitoPorParcelaDTO>> getPagamentoDebitoPorParcela(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicioPagamento") Long exercicioPagamento, @PathVariable(value="pagamento") Long pagamento) {
        return ResponseEntity.ok((Object)this.pagamentoDebitoService.findPagamentoDebitoPorParcelaByPagamento(entidade, exercicioPagamento, pagamento));
    }
}

