/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.dto.LogradouroTestadaRespostaDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.LogradouroTestadaResumoDTO;
import br.com.elotech.tributos.service.LogradouroTestadaService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logradouros-testada"})
public class LogradouroTestadaResource
extends CrudResource<LogradouroTestada, Long> {
    private LogradouroTestadaService logradouroTestadaService;

    public LogradouroTestadaResource(LogradouroTestadaService logradouroTestadaService) {
        this.logradouroTestadaService = logradouroTestadaService;
    }

    @GetMapping(path={"/resumo-dto"})
    public ResponseEntity<Page<LogradouroTestadaResumoDTO>> findLogradouroTestadaDTOByRsql(@RequestParam String search, Pageable pageable) {
        Page result = this.logradouroTestadaService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)result.map(LogradouroTestadaResumoDTO::from));
    }

    @GetMapping(path={"/{id}/resposta-logradouro"})
    public ResponseEntity<LogradouroTestadaRespostaDTO> findByIdLogradouroTestadaResposta(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.logradouroTestadaService.findByIdLogradouroTestadaResposta(id));
    }

    @PutMapping(path={"/{id}/resposta-logradouro"})
    public ResponseEntity<LogradouroTestadaRespostaDTO> saveRespostas(@PathVariable Long id, @RequestBody LogradouroTestadaRespostaDTO dto) {
        return ResponseEntity.ok((Object)this.logradouroTestadaService.saveRespostas(id, dto));
    }
}

