/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.domain.LivroRegistroId;
import br.com.elotech.tributos.dto.dividaativa.LivroRegistroDTO;
import br.com.elotech.tributos.dto.dividaativa.LivroRegistroParcelaDTO;
import br.com.elotech.tributos.service.LivroRegistroService;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/livro-registros"})
public class LivroRegistroResource
extends ReadOnlyResource<LivroRegistro, LivroRegistroId> {
    private final LivroRegistroService livroRegistroService;

    public LivroRegistroResource(LivroRegistroService livroRegistroService) {
        this.livroRegistroService = livroRegistroService;
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{livro}/search"})
    public ResponseEntity<Page<LivroRegistroDTO>> getLivroRegistros(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="livro") Long livro, @RequestParam Optional<String> search, Pageable page) {
        return ResponseEntity.ok((Object)this.livroRegistroService.searchItens(entidade, exercicio, livro, search.orElse(""), page));
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{livro}/{sequencia}/parcelas"})
    public ResponseEntity<List<LivroRegistroParcelaDTO>> getParcelaTributosByLivroRegistro(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="livro") Long livro, @PathVariable(value="sequencia") Long sequencia) {
        return ResponseEntity.ok((Object)this.livroRegistroService.getParcelaTributosByLivroRegistro(entidade, exercicio, livro, sequencia));
    }
}

