/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.LivroEstorno;
import br.com.elotech.tributos.dto.LivroEstornoDTO;
import br.com.elotech.tributos.dto.LivroEstornoRegistroDTO;
import br.com.elotech.tributos.service.LivroEstornoService;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/livros-estorno"})
public class LivroEstornoResource
extends CrudResource<LivroEstorno, Long> {
    private final LivroEstornoService livroEstornoService;

    public LivroEstornoResource(LivroEstornoService livroEstornoService) {
        this.livroEstornoService = livroEstornoService;
    }

    @PostMapping(value={"/por-livro"})
    public ResponseEntity<Void> estornarLivro(@RequestBody @Valid LivroEstornoDTO livroEstornoLivroDTO) {
        this.livroEstornoService.estornarPorLivro(livroEstornoLivroDTO.getEstornoComMotivoDeducao());
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/por-registros"})
    public ResponseEntity<Void> estornarLivroRegistros(@RequestBody @Valid LivroEstornoRegistroDTO livroEstornoRegistroDTO) {
        this.livroEstornoService.estornarPorRegistros(livroEstornoRegistroDTO.getEstornosComMotivoDeducao());
        return ResponseEntity.ok().build();
    }
}

