/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.DebitoObservacao;
import br.com.elotech.tributos.domain.DebitoObservacaoId;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/debito-observacoes"})
public class DebitoObservacaoResource {
    private final DebitoObservacaoService debitoObservacaoService;

    public DebitoObservacaoResource(DebitoObservacaoService debitoObservacaoService) {
        this.debitoObservacaoService = debitoObservacaoService;
    }

    @GetMapping(value={"/by-debito"}, params={"entidade", "exercicio", "tipoCadastro", "cadastroGeral", "divida", "subDivida"})
    public ResponseEntity<List<DebitoObservacao>> findByDebito(DebitoObservacaoId params) {
        return ResponseEntity.ok((Object)this.debitoObservacaoService.findByDebito(params.getEntidade(), params.getExercicio(), params.getTipoCadastro(), params.getCadastroGeral(), params.getDivida(), params.getSubDivida()));
    }

    @PostMapping
    public ResponseEntity<DebitoObservacao> saveObservacao(@RequestBody @Valid DebitoObservacao debitoObservacao) {
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.debitoObservacaoService.save(debitoObservacao));
    }
}

