/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.audit.domain.ChangeWithRevision;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.audit.AuditService;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.CadastroRuralDTO;
import br.com.elotech.tributos.dto.CadastroRuralRowDTO;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.cadastrorural.CadastroRuralItbiDTO;
import br.com.elotech.tributos.service.CadastroRuralService;
import br.com.elotech.tributos.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastro-rural"})
public class CadastroRuralResource
extends ReadOnlyResource<CadastroRural, Long> {
    private final CadastroRuralService cadastroRuralService;
    private final AuditService auditService;

    public CadastroRuralResource(CadastroRuralService cadastroRuralService, AuditService auditService) {
        this.cadastroRuralService = cadastroRuralService;
        this.auditService = auditService;
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<CadastroSearchDTO> searchCadastrosRurais(@RequestBody CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        return ResponseEntity.ok((Object)this.cadastroRuralService.searchCadastrosRurais(searchParams, pageable));
    }

    @GetMapping(value={"/{id}/por-data"})
    public ResponseEntity<CadastroRuralDTO> findByIdAtDate(@PathVariable Long id, @RequestParam(value="referenceDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime date) {
        CadastroRural cadastroRural = (CadastroRural)this.auditService.getRecordAtDate(CadastroRural.class, (Serializable)id, date);
        if (Objects.isNull(cadastroRural)) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar dados para o cadastro rural com ID %d na data %s.", id, DateUtils.localDateTimeToStringFormatoBrasileiro((LocalDateTime)date)));
        }
        return ResponseEntity.ok((Object)CadastroRuralDTO.fromComRespostaAgrupada((CadastroRural)cadastroRural));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<CadastroRuralRowDTO> getResumo(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.cadastroRuralService.findById((Serializable)id).map(CadastroRuralRowDTO::from).orElseThrow(() -> RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar o cadastro rural com ID %d.", id))));
    }

    @GetMapping(value={"/{id}/historico"})
    public ResponseEntity<Page<ChangeWithRevision>> getHistorico(@PathVariable(value="id") Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.auditService.getRevisionForEntity(CadastroRural.class, (Serializable)id, search, pageable));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteById(@PathVariable Long id) {
        this.cadastroRuralService.deleteById(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/find/{id}"})
    public ResponseEntity<CadastroRuralDTO> findCadastroRuralById(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.cadastroRuralService.findCadastroRuralDTO(id));
    }

    @PostMapping
    public ResponseEntity<CadastroRuralDTO> save(@Valid @RequestBody CadastroRuralDTO cadastroRuralDTO) {
        return ResponseEntity.ok((Object)this.cadastroRuralService.save(cadastroRuralDTO));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<CadastroRuralDTO> update(@PathVariable Long id, @Valid @RequestBody CadastroRuralDTO cadastroRuralDTO) {
        return ResponseEntity.ok((Object)this.cadastroRuralService.update(id, cadastroRuralDTO));
    }

    @GetMapping(value={"/itbi/{cadastro}"})
    public ResponseEntity<CadastroRuralItbiDTO> getCadastroRuralParaItbi(@PathVariable Long cadastro) {
        return ResponseEntity.ok((Object)this.cadastroRuralService.getCadastroRuralParaItbi(cadastro));
    }
}

