/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.EstornoArrecadacaoCreditoDTO;
import br.com.elotech.tributos.repository.simam.EstornoArrecadacaoCreditoCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EstornoArrecadacaoCreditoCustomRepositoryImpl
implements EstornoArrecadacaoCreditoCustomRepository {
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ENTIDADE = "entidade";
    private static final String PESSOA = "idPessoa";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<EstornoArrecadacaoCreditoDTO> findEstornos(Long entidade, Long idPessoa, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)idPessoa);
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlEstornos = FileUtils.readResourceAsString((String)"sql/simam/estornoArrecadacaoCredito.sql");
        return this.namedParameterJdbcTemplate.query(sqlEstornos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoArrecadacaoCreditoDTO.class));
    }

    @Generated
    public EstornoArrecadacaoCreditoCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

