/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.DeducaoCreditoDividaAtivaCargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.DeducaoDividaAtivaDTO;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoDividaAtivaCustomRepository;
import br.com.elotech.tributos.util.SqlUtils;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.support.DatabaseType;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DeducaoCreditoDividaAtivaCustomRepositoryImpl
implements DeducaoCreditoDividaAtivaCustomRepository {
    private final String sqlCargaExistente_Postgres = FileUtils.readResourceAsString((String)"sql/simam/deducaoCreditoDividaAtivaCargaExistente_postgres.sql");
    private final String sqlCargaExistente_Oracle = FileUtils.readResourceAsString((String)"sql/simam/deducaoCreditoDividaAtivaCargaExistente_oracle.sql");
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ENTIDADE = "entidade";
    private static final String PESSOA = "idPessoa";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<DeducaoCreditoDividaAtivaCargaExistenteDTO> getCargaExistenteDeducaoCreditoDividaAtiva(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        return this.namedParameterJdbcTemplate.query(this.getSqlCargaExistente(), (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DeducaoCreditoDividaAtivaCargaExistenteDTO.class));
    }

    private String getSqlCargaExistente() {
        return DatabaseType.POSTGRES.equals((Object)SqlUtils.getDatabaseType((DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource())) ? this.sqlCargaExistente_Postgres : this.sqlCargaExistente_Oracle;
    }

    private String getSqlUpdateValorFinal() {
        return String.format("update tcededucaocreditoda up set vldeducao = (select sum(w.valor) from (%s) w where w.id = up.idtcededucaocreditoda),  dsMotivo = (select substr(w.dsmotivo, 0, 250) from (%s) w where w.id = up.idtcededucaocreditoda) where up.dtdeducao between :dataInicial and :dataFinal ", this.getSqlCargaExistente(), this.getSqlCargaExistente());
    }

    public void atualizaValorFinal(@Param(value="entidade") Long entidade, @Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        this.namedParameterJdbcTemplate.update(this.getSqlUpdateValorFinal(), (SqlParameterSource)parameters);
    }

    public void verificarErrors(@Param(value="entidade") Long entidade, @Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        String nrDividaNaoLocalizado;
        List lista = this.getCargaExistenteDeducaoCreditoDividaAtiva(entidade, dataInicial, dataFinal);
        StringBuilder erros = new StringBuilder();
        String leiAtoNaoCadastrado = lista.stream().filter(item -> Objects.isNull(item.getCdControleLeiAto())).map(DeducaoCreditoDividaAtivaCargaExistenteDTO::getId).map(Object::toString).collect(Collectors.joining(", "));
        if (StringUtils.isNotBlank((CharSequence)leiAtoNaoCadastrado)) {
            erros.append("\n").append("Lei/Ato n\u00e3o localizado para os Ids: ").append(leiAtoNaoCadastrado);
        }
        if (StringUtils.isNotBlank((CharSequence)(nrDividaNaoLocalizado = lista.stream().filter(item -> Objects.isNull(item.getNrDivida())).map(DeducaoCreditoDividaAtivaCargaExistenteDTO::getId).map(Object::toString).collect(Collectors.joining(", "))))) {
            erros.append("\n").append("NrDivida n\u00e3o localizada para os Ids: ").append(nrDividaNaoLocalizado);
        }
        if (StringUtils.isNotBlank((CharSequence)erros.toString())) {
            throw new EloValidationException(erros.toString());
        }
    }

    public List<DeducaoDividaAtivaDTO> findLancamentos(@Param(value="idPessoa") Long idPessoa, @Param(value="entidade") Long entidade, @Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)idPessoa);
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/deducaoCreditoDividaAtivaLancamentos.sql");
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DeducaoDividaAtivaDTO.class));
    }

    @Generated
    public DeducaoCreditoDividaAtivaCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

