/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.ClassificacaoTributo;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoParcelamentoDTO;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoParcelamentoNrCreditoDTO;
import br.com.elotech.tributos.repository.simam.AtualizacaoCreditoParcelamentoCustomRepository;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AtualizacaoCreditoParcelamentoCustomRepositoryImpl
implements AtualizacaoCreditoParcelamentoCustomRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<AtualizacaoCreditoParcelamentoDTO> loadParcelamento(String receitaPrincipal, Long idParcelamento, Long entidade, Long exercicio) {
        String sqlParcelamentoReceita = FileUtils.readResourceAsString((String)"sql/simam/atualizacaoCreditoParcelamento.sql");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("receitaPrincipal", (Object)receitaPrincipal);
        parameters.addValue("idparcelamento", (Object)idParcelamento);
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exercicio", (Object)exercicio);
        return this.namedParameterJdbcTemplate.query(sqlParcelamentoReceita, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoCreditoParcelamentoDTO.class));
    }

    public List<AtualizacaoCreditoParcelamentoNrCreditoDTO> loadParcelamentoNrCredito(ClassificacaoTributo classificacao, Long idParcelamento, String receitaPrincipal, String receita, Long entidade, Long exercicio) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("receitaPrincipal", (Object)receitaPrincipal);
        parameters.addValue("idparcelamento", (Object)idParcelamento);
        parameters.addValue("receita", (Object)receita);
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exercicio", (Object)exercicio);
        StringBuilder sqlParcelamentoReceita = new StringBuilder();
        sqlParcelamentoReceita.append("select distinct tppro.idparcelamento,        tppro.iddebitoparcelareceita,        tppro.percentual,        tlc.nrcredito,        tlc.nranocredito,        ca.idTce as cdControleLeiAto  from tribParcelamentoParcRecOrigem tppro  left join tcedebitolanccredito     tdlc  on tdlc.iddebitoparcelareceita = tppro.iddebitoparcelareceita  left join tcelanccredito           tlc   on tlc.idTceLancCredito = tdlc.idtcelanccredito  join tribdebitoparcelareceita      tdpr  on tdpr.iddebitoparcelareceita = tppro.iddebitoparcelareceita  join tribdebito                    td    on tdpr.entidade = td.entidade and tdpr.exercicio = td.exercicio                                          and tdpr.tipocadastro = td.tipocadastro and tdpr.cadastrogeral = td.cadastrogeral                                          and tdpr.guiarecolhimento = td.guiarecolhimento and tdpr.subdivida = td.subdivida  left join tribguiarecolhimento     tg    on tg.entidade = :entidade                                         and tg.exercicio  = :exercicio                                         and tg.guiarecolhimento = td.guiarecolhimento  left join cgato                    ca    on ca.entidade = tg.entidade and ca.idato = tg.fundamentolegal  join tribparcelamentoreceitaespelho tgre on tgre.idparcelamento = tppro.idparcelamento                                         and tgre.iddebito = td.iddebito                                         and tgre.receitaorigem = tdpr.receita  where tppro.idparcelamento = :idparcelamento ");
        if (ClassificacaoTributo.JUROS.equals((Object)classificacao)) {
            sqlParcelamentoReceita.append(" and tgre.jurosdestino = :receita ");
        }
        if (ClassificacaoTributo.MULTA.equals((Object)classificacao)) {
            sqlParcelamentoReceita.append(" and tgre.multadestino = :receita ");
        }
        if (ClassificacaoTributo.CORRECAO.equals((Object)classificacao)) {
            sqlParcelamentoReceita.append(" and tgre.correcaodestino = :receita ");
        }
        if (ClassificacaoTributo.JUROS_FINANCIAMENTO.equals((Object)classificacao)) {
            sqlParcelamentoReceita.append(" and tgre.jurosfinandestino  = :receita ");
        }
        sqlParcelamentoReceita.append("  and tgre.receitaorigem = :receitaPrincipal ");
        return this.namedParameterJdbcTemplate.query(sqlParcelamentoReceita.toString(), (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoCreditoParcelamentoNrCreditoDTO.class));
    }

    @Generated
    public AtualizacaoCreditoParcelamentoCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

