/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.ArrecadacaoCreditoCargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.ArrecadacaoCreditoDTO;
import br.com.elotech.tributos.repository.simam.ArrecadacaoCreditoCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ArrecadacaoCreditoCustomRepositoryImpl
implements ArrecadacaoCreditoCustomRepository {
    private final String sqlCargaExistente = FileUtils.readResourceAsString((String)"sql/simam/arrecadacaoCreditoCargaExistente.sql");
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ENTIDADE = "entidade";
    private static final String PESSOA = "idPessoa";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<ArrecadacaoCreditoCargaExistenteDTO> getCargaExistente(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        return this.namedParameterJdbcTemplate.query(this.sqlCargaExistente, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoCreditoCargaExistenteDTO.class));
    }

    private String getSqlUpdateValorFinal() {
        return String.format("update tcearrecadacaotipocredito up set vlarrecadacao = (select sum(w.valor) from (%s) w where w.idtcearrtipocredito = up.idtcearrtipocredito) where up.idtcearrtipocredito in (select distinct idtcearrtipocredito from (%s)) ", this.sqlCargaExistente, this.sqlCargaExistente);
    }

    public void atualizaValorFinal(@Param(value="entidade") Long entidade, @Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        this.namedParameterJdbcTemplate.update(this.getSqlUpdateValorFinal(), (SqlParameterSource)parameters);
    }

    public void verificarErrors(@Param(value="entidade") Long entidade, @Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        String nrDividaNaoLocalizada;
        List lista = this.getCargaExistente(entidade, dataInicial, dataFinal);
        StringBuilder erros = new StringBuilder();
        String nrCreditoNaoLocalizado = lista.stream().filter(item -> 1L == item.getIdTipoOrigemReceita()).filter(item -> Objects.isNull(item.getNrCredito())).map(ArrecadacaoCreditoCargaExistenteDTO::getIdTceArrTipoCredito).map(Object::toString).collect(Collectors.joining(", "));
        if (StringUtils.isNotBlank((CharSequence)nrCreditoNaoLocalizado)) {
            erros.append("\n").append("NrCredito n\u00e3o localizado para os Ids: ").append(nrCreditoNaoLocalizado);
        }
        if (StringUtils.isNotBlank((CharSequence)(nrDividaNaoLocalizada = lista.stream().filter(item -> 2L == item.getIdTipoOrigemReceita()).filter(item -> Objects.isNull(item.getNrDivida())).map(ArrecadacaoCreditoCargaExistenteDTO::getIdTceArrTipoCredito).map(Object::toString).collect(Collectors.joining(", "))))) {
            erros.append("\n").append("NrDivida n\u00e3o localizada para os Ids: ").append(nrDividaNaoLocalizada);
        }
        if (StringUtils.isNotBlank((CharSequence)erros.toString())) {
            throw new EloValidationException(erros.toString());
        }
    }

    public List<ArrecadacaoCreditoDTO> findArrecadacoes(Long idPessoa, Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)idPessoa);
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/arrecadacaoCreditoLancamentos.sql");
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoCreditoDTO.class));
    }

    @Generated
    public ArrecadacaoCreditoCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

