/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.TributoDTO;
import br.com.elotech.tributos.params.DebitoFilterParams;
import br.com.elotech.tributos.params.DebitoTributoPorcentagemParams;
import br.com.elotech.tributos.repository.DebitoParcelaTributoCustomRepository;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoParcelaTributoRepositoryImpl
implements DebitoParcelaTributoCustomRepository {
    private static final String TIPO_CADASTRO = "tipoCadastro";
    private static final String ENTIDADE = "entidade";
    private static final String SITUACOES_LEGAL = "situacoesLegais";
    private static final String TRIBUTO = "tributo";
    private static final String PERCENTUAL = "percentual";
    private static final String SITUACOES_LEGAIS = "situacoesLegais";
    private static final String SQL_PARCELAS_CANCELAMENTO = "br/com/elotech/tributos/repository/find-parcelas-cancelamento.sql";
    private static final String SQL_TRIBUTOS_DESCRICAO = "br/com/elotech/tributos/repository/findTributoDescricao.sql";
    private static final String SQL_PARCELA_TRIBUTO_CANCELAMENTO = "br/com/elotech/tributos/repository/find-parcelas-tributo-cancelamento.sql";
    private static final String AND = " AND ";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public DebitoParcelaTributoRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<TributoDTO> findDebitoDescricao(DebitoFilterParams params, List<Integer> situacoesLegais) {
        String sql = FileUtils.readResourceAsString((String)SQL_TRIBUTOS_DESCRICAO);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)params.getEntidade());
        parameters.addValue(TIPO_CADASTRO, (Object)params.getTipoCadastro());
        parameters.addValue("situacoesLegais", situacoesLegais);
        sql = this.addFilterDebitoMultiValue(params, sql);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(TributoDTO.class));
    }

    public List<CancelamentoDebitoTributoDTO> findByDebitoAndAberto(DebitoFilterParams debito, List<Integer> situacoesLegal) {
        String sql = FileUtils.readResourceAsString((String)SQL_PARCELAS_CANCELAMENTO);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)debito.getEntidade());
        parameters.addValue(TIPO_CADASTRO, (Object)debito.getTipoCadastro());
        parameters.addValue("situacoesLegais", situacoesLegal);
        sql = this.addFilterDebitoMultiValue(debito, sql);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CancelamentoDebitoTributoDTO.class));
    }

    private String addFilterDebitoMultiValue(DebitoFilterParams debito, String sql) {
        StringBuilder selects = new StringBuilder();
        StringBuilder filtros = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)debito.getExercicio())) {
            filtros.append(AND);
            filtros.append(MultiValueFilter.generateFilters((String)debito.getExercicio(), (String)"dpr.EXERCICIO"));
        }
        if (StringUtils.isNotBlank((CharSequence)debito.getCadastroGeral())) {
            filtros.append(AND);
            filtros.append(MultiValueFilter.generateFilters((String)debito.getCadastroGeral(), (String)"dpr.CADASTROGERAL"));
        }
        if (StringUtils.isNotBlank((CharSequence)debito.getDivida())) {
            selects.append(" dpr.guiarecolhimento as divida, ");
            filtros.append(AND);
            filtros.append(MultiValueFilter.generateFilters((String)debito.getDivida(), (String)"dpr.GUIARECOLHIMENTO"));
        }
        if (StringUtils.isNotBlank((CharSequence)debito.getSubDivida())) {
            selects.append(" dpr.subdivida, ");
            filtros.append(AND);
            filtros.append(MultiValueFilter.generateFilters((String)debito.getSubDivida(), (String)"dpr.SUBDIVIDA"));
        }
        return sql.replace("$[SELECTS]", selects.toString()).replace("$[FILTROS]", filtros.toString());
    }

    public List<CancelamentoDebitoTributoDTO> findDebitoParcelaTributoCancelamento(DebitoFilterParams debitoFilterParams, DebitoTributoPorcentagemParams tributos, List<Integer> situacoesLegais) {
        String sql = FileUtils.readResourceAsString((String)SQL_PARCELA_TRIBUTO_CANCELAMENTO);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)debitoFilterParams.getEntidade());
        parameters.addValue(TIPO_CADASTRO, (Object)debitoFilterParams.getTipoCadastro());
        parameters.addValue(TRIBUTO, (Object)tributos.getTributo());
        parameters.addValue(PERCENTUAL, (Object)tributos.getPorcentagem(), 3);
        parameters.addValue("situacoesLegais", situacoesLegais);
        sql = this.addFilterDebitoMultiValue(debitoFilterParams, sql);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CancelamentoDebitoTributoDTO.class));
    }
}

