/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.dto.BaixaAutomaticaCadastroDTO;
import br.com.elotech.tributos.repository.BaixaAutomaticaDetalheRepositoryCustom;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class BaixaAutomaticaDetalheRepositoryImpl
implements BaixaAutomaticaDetalheRepositoryCustom {
    private static final String CNPJ_CPF_FIELD = "CNPJ_CPF";
    private static final String SQL_FILTRO_PADRAO = "and p.TipoPessoa = 'J' and cg.ExclusaoLogica = 'N' Order By cg.CadastroGeral ";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public BaixaAutomaticaDetalheRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Optional<BaixaAutomaticaCadastroDTO> findCadastroMobiliarioByCnpj(String cnpj) {
        String sql = "Select cg.TipoCadastro,cg.CadastroGeral,cg.Pessoa,sm.TipoSituacaoMobiliario From Pessoa p Inner Join TribCadastroGeral cg On cg.Pessoa = p.Pessoa Inner Join TribCadastroMobiliario cm On cm.TipoCadastro = cg.TipoCadastro and cm.CadastroGeral = cg.CadastroGeral Inner Join TribMobiliarioSituacao ms On ms.TipoCadastro = cm.TipoCadastro and ms.CadastroGeral = cm.CadastroGeral Inner Join TribSituacaoMobiliario sm On sm.SituacaoMobiliario = ms.SituacaoMobiliario Where ms.Atual = 'S' and sm.TipoSituacaoMobiliario <> 7 and p.CNPJ_CPF = :CNPJ_CPF and p.TipoPessoa = 'J' and cg.ExclusaoLogica = 'N' Order By cg.CadastroGeral ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(CNPJ_CPF_FIELD, (Object)cnpj);
        List listaCadastro = this.jdbcTemplate.query("Select cg.TipoCadastro,cg.CadastroGeral,cg.Pessoa,sm.TipoSituacaoMobiliario From Pessoa p Inner Join TribCadastroGeral cg On cg.Pessoa = p.Pessoa Inner Join TribCadastroMobiliario cm On cm.TipoCadastro = cg.TipoCadastro and cm.CadastroGeral = cg.CadastroGeral Inner Join TribMobiliarioSituacao ms On ms.TipoCadastro = cm.TipoCadastro and ms.CadastroGeral = cm.CadastroGeral Inner Join TribSituacaoMobiliario sm On sm.SituacaoMobiliario = ms.SituacaoMobiliario Where ms.Atual = 'S' and sm.TipoSituacaoMobiliario <> 7 and p.CNPJ_CPF = :CNPJ_CPF and p.TipoPessoa = 'J' and cg.ExclusaoLogica = 'N' Order By cg.CadastroGeral ", (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(BaixaAutomaticaCadastroDTO.class));
        return listaCadastro.stream().findFirst();
    }

    public Optional<BaixaAutomaticaCadastroDTO> findCadastroMobiliarioByCnpjRaiz(String cnpj) {
        String sql = "Select cg.TipoCadastro,cg.CadastroGeral,cg.Pessoa,sm.TipoSituacaoMobiliario From Pessoa p Inner Join TribCadastroGeral cg On cg.Pessoa = p.Pessoa Inner Join TribCadastroMobiliario cm On cm.TipoCadastro = cg.TipoCadastro and cm.CadastroGeral = cg.CadastroGeral Inner Join TribMobiliarioSituacao ms On ms.TipoCadastro = cm.TipoCadastro and ms.CadastroGeral = cm.CadastroGeral Inner Join TribSituacaoMobiliario sm On sm.SituacaoMobiliario = ms.SituacaoMobiliario Where ms.Atual = 'S' and sm.TipoSituacaoMobiliario <> 7 and p.CNPJ_CPF <> :CNPJ_CPF_Original and p.CNPJ_CPF like :CNPJ_CPF and p.TipoPessoa = 'J' and cg.ExclusaoLogica = 'N' Order By cg.CadastroGeral ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(CNPJ_CPF_FIELD, (Object)(StringUtils.substring((String)cnpj, (int)0, (int)8) + "%"));
        parameters.addValue("CNPJ_CPF_Original", (Object)cnpj);
        List listaCadastro = this.jdbcTemplate.query("Select cg.TipoCadastro,cg.CadastroGeral,cg.Pessoa,sm.TipoSituacaoMobiliario From Pessoa p Inner Join TribCadastroGeral cg On cg.Pessoa = p.Pessoa Inner Join TribCadastroMobiliario cm On cm.TipoCadastro = cg.TipoCadastro and cm.CadastroGeral = cg.CadastroGeral Inner Join TribMobiliarioSituacao ms On ms.TipoCadastro = cm.TipoCadastro and ms.CadastroGeral = cm.CadastroGeral Inner Join TribSituacaoMobiliario sm On sm.SituacaoMobiliario = ms.SituacaoMobiliario Where ms.Atual = 'S' and sm.TipoSituacaoMobiliario <> 7 and p.CNPJ_CPF <> :CNPJ_CPF_Original and p.CNPJ_CPF like :CNPJ_CPF and p.TipoPessoa = 'J' and cg.ExclusaoLogica = 'N' Order By cg.CadastroGeral ", (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(BaixaAutomaticaCadastroDTO.class));
        return listaCadastro.stream().findFirst();
    }

    public Optional<BaixaAutomaticaCadastroDTO> findCadastroAvulsoByCnpj(String cnpj) {
        String sql = "Select cg.TipoCadastro,cg.CadastroGeral,cg.Pessoa From Pessoa p Inner Join TribCadastroGeral cg On cg.Pessoa = p.Pessoa Where cg.TipoCadastro = 9 and p.CNPJ_CPF = :CNPJ_CPF and p.TipoPessoa = 'J' and cg.ExclusaoLogica = 'N' Order By cg.CadastroGeral ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(CNPJ_CPF_FIELD, (Object)cnpj);
        List listaCadastro = this.jdbcTemplate.query("Select cg.TipoCadastro,cg.CadastroGeral,cg.Pessoa From Pessoa p Inner Join TribCadastroGeral cg On cg.Pessoa = p.Pessoa Where cg.TipoCadastro = 9 and p.CNPJ_CPF = :CNPJ_CPF and p.TipoPessoa = 'J' and cg.ExclusaoLogica = 'N' Order By cg.CadastroGeral ", (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(BaixaAutomaticaCadastroDTO.class));
        return listaCadastro.stream().findFirst();
    }
}

