/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.DocumentoItemPeticaoDTO;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DocumentoPeticaoRepository {
    private static final String SQL_PETICAO = "br/com/elotech/tributos/repository/find-certidao-divida-ativa-por-peticao.sql";
    private static final String SQL_DEBITO_PARCELA_PETICAO = "br/com/elotech/tributos/repository/find-debito-parcela-por-peticao.sql";
    private static final String SQL_PETICAO_COM_CDA = "br/com/elotech/tributos/repository/find-peticao-vinculado-com-certidao-divida-ativa.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public DocumentoPeticaoRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<DocumentoItemPeticaoDTO> findAllDocumentoPeticaoCdaByPeticao(Long idPeticao) {
        String sql = FileUtils.readResourceAsString((String)SQL_PETICAO);
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("idPeticao", (Object)idPeticao);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(DocumentoItemPeticaoDTO.class));
    }

    public List<DebitoParcelaDTO> findDebitoParcelasPorPeticao(Long idDocumento) {
        String sql = FileUtils.readResourceAsString((String)SQL_DEBITO_PARCELA_PETICAO);
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("documento", (Object)idDocumento);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoParcelaDTO.class));
    }

    public List<DocumentoItemPeticaoDTO> findPeticaoVinculadaComCDA(Long entidade, Long exercicioCertidao, Long documentoCertidao) {
        String sql = FileUtils.readResourceAsString((String)SQL_PETICAO_COM_CDA);
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("entidade", (Object)entidade);
        parameterSource.addValue("exercicioCertidao", (Object)exercicioCertidao);
        parameterSource.addValue("tipoDocumentoCertidao", (Object)TipoDocumentoEnum.CERTIDAO_DIVIDA_ATIVA.getValue());
        parameterSource.addValue("documentoCertidao", (Object)documentoCertidao);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(DocumentoItemPeticaoDTO.class));
    }
}

