/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.fluent.dataset.ReportDatasets;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.EntidadeRepository;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ConsultaImplantacaoSaldoParamLoader
implements ParamLoader {
    public static final String PARAM_NOME_ENTIDADE = "PNomeEntidade";
    public static final String PARAM_ESTADO = "PEstado";
    public static final String PARAM_BRASAO = "PBrasao";
    private final EntidadeRepository entidadeRepository;

    public ConsultaImplantacaoSaldoParamLoader(EntidadeRepository entidadeRepository) {
        this.entidadeRepository = entidadeRepository;
    }

    public Set<Param> load(ReportDatasets datasets) {
        HashSet params = Sets.newHashSet();
        Entidade entidadeprincipal = this.entidadeRepository.findByEntidadeprincipal();
        params.add(Param.of((String)PARAM_NOME_ENTIDADE, (Object)entidadeprincipal.getNome()));
        params.add(Param.of((String)PARAM_ESTADO, (Object)"Estado do Paran\u00e1"));
        if (Objects.nonNull(entidadeprincipal.getBrasao()) && entidadeprincipal.getBrasao().length > 0) {
            params.add(Param.of((String)PARAM_BRASAO, (Object)new ByteArrayInputStream(entidadeprincipal.getBrasao())));
        }
        return params;
    }
}

