/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.cadastroimobiliario;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CadastroGeralObservacao;
import br.com.elotech.tributos.domain.CadastroGeralObservacaoId;
import java.time.LocalDate;
import lombok.Generated;

public class ObservacaoDTO {
    private Long sequencia;
    private String descricao;
    private LocalDate data;
    private String usuario;

    public static ObservacaoDTO from(CadastroGeralObservacao entity) {
        ObservacaoDTO dto = new ObservacaoDTO();
        dto.setSequencia(entity.getId().getSequencia());
        dto.setDescricao(entity.getDescricao());
        dto.setData(entity.getData());
        dto.setUsuario(entity.getUsuario());
        return dto;
    }

    public CadastroGeralObservacao toEntity(CadastroGeral cadastroGeral) {
        CadastroGeralObservacao entity = new CadastroGeralObservacao();
        entity.setId(CadastroGeralObservacaoId.builder().cadastroGeral(cadastroGeral.getCadastroGeral()).tipoCadastro(cadastroGeral.getTipoCadastro().getValue()).sequencia(this.getSequencia()).build());
        entity.setCadastroGeral(cadastroGeral);
        entity.setData(this.getData());
        entity.setUsuario(this.getUsuario());
        entity.setDescricao(this.descricao);
        return entity;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObservacaoDTO)) {
            return false;
        }
        ObservacaoDTO other = (ObservacaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        return !(this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ObservacaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ObservacaoDTO(sequencia=" + this.getSequencia() + ", descricao=" + this.getDescricao() + ", data=" + this.getData() + ", usuario=" + this.getUsuario() + ")";
    }

    @Generated
    public ObservacaoDTO(Long sequencia, String descricao, LocalDate data, String usuario) {
        this.sequencia = sequencia;
        this.descricao = descricao;
        this.data = data;
        this.usuario = usuario;
    }

    @Generated
    public ObservacaoDTO() {
    }
}

