/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.exception.DebitoHandlerException;
import br.com.elotech.tributos.ws.rest.dto.DebitoGenericDTO;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DebitoHandler {
    private DebitoHandler() {
    }

    public static List<DebitoDTO> hierarquiaDebito(Map<Long, List<DebitoDTO>> agrupados) {
        ArrayList resultadoAgrupado = Lists.newArrayList();
        agrupados.forEach((chave, lista) -> resultadoAgrupado.add(DebitoHandler.hierarquiaDebito((List)lista)));
        return resultadoAgrupado;
    }

    public static DebitoDTO hierarquiaDebito(List<DebitoDTO> debitos) {
        DebitoDTO debitoParent;
        try {
            debitoParent = (DebitoDTO)BeanUtils.cloneBean((Object)debitos.get(0));
        }
        catch (Exception ex) {
            throw new DebitoHandlerException("Erro ao clonar o d\u00e9bito", ex);
        }
        debitoParent.addDebito(debitos.remove(0));
        debitos.stream().sorted(Comparator.comparing(DebitoDTO::getVencimento)).forEach(debito -> {
            debitoParent.addDebito(debito);
            debitoParent.somaValor(debito);
        });
        return debitoParent;
    }

    public static List<DebitoDTO> debitosNaoContemNumeroContrato(List<DebitoDTO> debitos) {
        return debitos.stream().filter(DebitoDTO::naoContemNumeroContrato).collect(Collectors.toList());
    }

    public static Map<Long, Map<Long, List<DebitoDTO>>> agrupaPorNumeroContratoEParcela(List<DebitoDTO> debitos) {
        return debitos.stream().filter(DebitoDTO::contemNumeroContrato).collect(Collectors.groupingBy(DebitoDTO::getNumeroContrato, Collectors.groupingBy(DebitoDTO::getParcela)));
    }

    public static List<DebitoDTO> agrupaDebitoMobile(List<DebitoDTO> debitos) {
        ArrayList resultadoAgrupadoPorDebito = Lists.newArrayList();
        List listDebitoDTO = DebitoHandler.agrupaContratoParcela(debitos);
        resultadoAgrupadoPorDebito.addAll(DebitoHandler.agrupaParcelaDebitoNaoParcelado((List)listDebitoDTO));
        resultadoAgrupadoPorDebito.addAll(DebitoHandler.agrupaParcelaDebitoParcelado((List)listDebitoDTO));
        return resultadoAgrupadoPorDebito;
    }

    public static List<DebitoDTO> agrupaContratoParcela(List<DebitoDTO> debitos) {
        ArrayList resultadoAgrupado = Lists.newArrayList();
        Map agrupados = DebitoHandler.agrupaPorNumeroContratoEParcela(debitos);
        agrupados.forEach((chave, lista) -> resultadoAgrupado.addAll(DebitoHandler.hierarquiaDebito((Map)lista)));
        DebitoHandler.debitosNaoContemNumeroContrato(debitos).forEach(debito -> resultadoAgrupado.add(DebitoHandler.hierarquiaDebito((List)Lists.newArrayList((Object[])new DebitoDTO[]{debito}))));
        resultadoAgrupado.sort(Comparator.comparing(DebitoGenericDTO::getTipoCadastro, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(DebitoGenericDTO::getCadastroGeral, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(DebitoDTO::getAnoContrato, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(DebitoDTO::getNumeroContrato, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(DebitoGenericDTO::getExercicio, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(DebitoGenericDTO::getGuiaRecolhimento, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(DebitoGenericDTO::getSubDivida, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(DebitoDTO::getParcela, Comparator.nullsLast(Comparator.naturalOrder())));
        return resultadoAgrupado;
    }

    private static List<DebitoDTO> agrupaParcelaDebitoNaoParcelado(List<DebitoDTO> listDebitoDTO) {
        ArrayList result = Lists.newArrayList();
        Map debitosAgrupados = DebitoHandler.agrupaPorDebito(listDebitoDTO);
        debitosAgrupados.forEach((chave, lista) -> {
            DebitoDTO debitoDTO = (DebitoDTO)lista.get(0);
            Optional<BigDecimal> valorTotal = lista.stream().map(DebitoGenericDTO::getValor).reduce(BigDecimal::add);
            valorTotal.ifPresent(arg_0 -> ((DebitoDTO)debitoDTO).setValor(arg_0));
            result.add(debitoDTO);
        });
        return result;
    }

    private static List<DebitoDTO> agrupaParcelaDebitoParcelado(List<DebitoDTO> listDebitoDTO) {
        ArrayList result = Lists.newArrayList();
        Map parcelamentosAgrupados = DebitoHandler.agrupaPorParcelamento(listDebitoDTO);
        parcelamentosAgrupados.forEach((chave, lista) -> {
            DebitoDTO debitoDTO = (DebitoDTO)lista.get(0);
            debitoDTO.setExercicio(debitoDTO.getAnoContrato());
            Optional<BigDecimal> valorTotal = lista.stream().map(DebitoGenericDTO::getValor).reduce(BigDecimal::add);
            valorTotal.ifPresent(arg_0 -> ((DebitoDTO)debitoDTO).setValor(arg_0));
            result.add(debitoDTO);
        });
        return result;
    }

    private static Map<Long, List<DebitoDTO>> agrupaPorDebito(List<DebitoDTO> debitos) {
        return debitos.stream().filter(DebitoDTO::naoContemNumeroContrato).collect(Collectors.groupingBy(DebitoDTO::getIdDebito));
    }

    private static Map<Long, List<DebitoDTO>> agrupaPorParcelamento(List<DebitoDTO> debitos) {
        return debitos.stream().filter(DebitoDTO::contemNumeroContrato).collect(Collectors.groupingBy(DebitoDTO::getIdDebito));
    }
}

