/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.CreditoContribuinte;
import br.com.elotech.tributos.domain.CreditoContribuinteItem;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.dto.CreditoContribuinteItemDTO;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class CreditoContribuinteDTO {
    private Long entidade;
    private Long exercicio;
    private Long creditoContribuinte;
    private Long exercicioLote;
    private Long lote;
    private Long sequenciaLote;
    private Long idBoleto;
    private Long boleto;
    private Long exercicioBoleto;
    private String conta;
    private String agencia;
    private Long banco;
    private String descricaoBanco;
    private LocalDate dataMovimento;
    private LocalDate dataPagamento;
    private LocalDate dataCredito;
    private LocalDate dataLote;
    private LocalDate dataEstorno;
    private String usuario;
    private String usuarioEstorno;
    private String motivoDeducaoEstorno;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorLancado = BigDecimal.ZERO;
    private BigDecimal valorDevolvido = BigDecimal.ZERO;
    private BigDecimal valorEstornado = BigDecimal.ZERO;
    private List<CreditoContribuinteItemDTO> porParcelas = new ArrayList();
    private List<CreditoContribuinteItemDTO> porTributos = new ArrayList();
    private List<DevolucaoCreditoDTO> devolucoes = new ArrayList();

    public static CreditoContribuinteDTO from(CreditoContribuinte entity) {
        CreditoContribuinteDTO creditoContribuinteDTO = new CreditoContribuinteDTO();
        creditoContribuinteDTO.entidade = entity.getId().getEntidade();
        creditoContribuinteDTO.exercicio = entity.getId().getExercicio();
        creditoContribuinteDTO.creditoContribuinte = entity.getId().getCreditoContribuinte();
        creditoContribuinteDTO.exercicioLote = entity.getLote().getId().getExercicio();
        creditoContribuinteDTO.lote = entity.getLote().getId().getLote();
        creditoContribuinteDTO.sequenciaLote = entity.getSequenciaArquivo();
        creditoContribuinteDTO.dataLote = entity.getLote().getDataLote();
        creditoContribuinteDTO.idBoleto = entity.getBoleto().getId();
        creditoContribuinteDTO.boleto = entity.getBoleto().getBloqueto();
        creditoContribuinteDTO.exercicioBoleto = entity.getBoleto().getExercicioBloqueto();
        creditoContribuinteDTO.conta = entity.getContaBancaria().getConta();
        if (Objects.nonNull(entity.getContaBancaria().getAgencia())) {
            creditoContribuinteDTO.agencia = entity.getContaBancaria().getAgencia().getAgencia();
            creditoContribuinteDTO.banco = entity.getContaBancaria().getAgencia().getBanco().getId();
            creditoContribuinteDTO.descricaoBanco = entity.getContaBancaria().getAgencia().getBanco().getDescricao();
        }
        creditoContribuinteDTO.dataMovimento = entity.getDataMovimento();
        creditoContribuinteDTO.dataPagamento = entity.getDataPagamento();
        creditoContribuinteDTO.dataCredito = entity.getDataMovimento();
        creditoContribuinteDTO.usuario = entity.getUsuario();
        if (Objects.nonNull(entity.getDataEstorno())) {
            creditoContribuinteDTO.dataEstorno = entity.getDataEstorno();
            creditoContribuinteDTO.usuarioEstorno = entity.getUsuarioEstorno();
            if (Objects.nonNull(entity.getMotivoDeducaoEstorno())) {
                creditoContribuinteDTO.motivoDeducaoEstorno = entity.getMotivoDeducaoEstorno().getDescricao();
            }
        }
        entity.getItens().forEach(creditoContribuinteItem -> {
            CreditoContribuinteItemDTO itemDTO = CreditoContribuinteItemDTO.from((CreditoContribuinteItem)creditoContribuinteItem);
            creditoContribuinteDTO.valorPrincipal = creditoContribuinteDTO.valorPrincipal.add(itemDTO.getValorPrincipal());
            creditoContribuinteDTO.valorCorrecao = creditoContribuinteDTO.valorCorrecao.add(itemDTO.getValorCorrecao());
            creditoContribuinteDTO.valorJuros = creditoContribuinteDTO.valorJuros.add(itemDTO.getValorJuros());
            creditoContribuinteDTO.valorMulta = creditoContribuinteDTO.valorMulta.add(itemDTO.getValorMulta());
            creditoContribuinteDTO.valorDesconto = creditoContribuinteDTO.valorDesconto.add(itemDTO.getValorDesconto());
            creditoContribuinteDTO.valorLancado = creditoContribuinteDTO.valorLancado.add(itemDTO.getValorLancado());
            creditoContribuinteDTO.valorDevolvido = creditoContribuinteDTO.valorDevolvido.add(itemDTO.getValorDevolvido());
            creditoContribuinteDTO.valorEstornado = creditoContribuinteDTO.valorEstornado.add(itemDTO.getValorEstornado());
            creditoContribuinteDTO.porTributos.add(itemDTO);
        });
        Map<DebitoParcelaId, List<CreditoContribuinteItemDTO>> agrupadosPorParcela = creditoContribuinteDTO.porTributos.stream().collect(Collectors.groupingBy(cancelamentoDebitoParcelaDTO -> DebitoParcelaId.builder().tipoCadastro(cancelamentoDebitoParcelaDTO.getTipoCadastro()).cadastroGeral(cancelamentoDebitoParcelaDTO.getCadastroGeral()).divida(cancelamentoDebitoParcelaDTO.getDivida()).subDivida(cancelamentoDebitoParcelaDTO.getSubDivida()).parcela(cancelamentoDebitoParcelaDTO.getParcela()).build()));
        agrupadosPorParcela.values().forEach(itensAgrupadosPorParcela -> {
            CreditoContribuinteItemDTO itemAgrupado = itensAgrupadosPorParcela.stream().reduce(new CreditoContribuinteItemDTO(), (acc, current) -> {
                acc.setTipoCadastro(current.getTipoCadastro());
                acc.setCadastroGeral(current.getCadastroGeral());
                acc.setExercicio(current.getExercicio());
                acc.setDivida(current.getDivida());
                acc.setSubDivida(current.getSubDivida());
                acc.setParcela(current.getParcela());
                acc.setValorPrincipal(acc.getValorPrincipal().add(current.getValorPrincipal()));
                acc.setValorCorrecao(acc.getValorCorrecao().add(current.getValorCorrecao()));
                acc.setValorJuros(acc.getValorJuros().add(current.getValorJuros()));
                acc.setValorMulta(acc.getValorMulta().add(current.getValorMulta()));
                acc.setValorDesconto(acc.getValorDesconto().add(current.getValorDesconto()));
                acc.setValorLancado(acc.getValorLancado().add(current.getValorLancado()));
                acc.setValorDevolvido(acc.getValorDevolvido().add(current.getValorDevolvido()));
                acc.setValorEstornado(acc.getValorEstornado().add(current.getValorEstornado()));
                return acc;
            });
            creditoContribuinteDTO.porParcelas.add(itemAgrupado);
        });
        return creditoContribuinteDTO;
    }

    @Generated
    public CreditoContribuinteDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getCreditoContribuinte() {
        return this.creditoContribuinte;
    }

    @Generated
    public Long getExercicioLote() {
        return this.exercicioLote;
    }

    @Generated
    public Long getLote() {
        return this.lote;
    }

    @Generated
    public Long getSequenciaLote() {
        return this.sequenciaLote;
    }

    @Generated
    public Long getIdBoleto() {
        return this.idBoleto;
    }

    @Generated
    public Long getBoleto() {
        return this.boleto;
    }

    @Generated
    public Long getExercicioBoleto() {
        return this.exercicioBoleto;
    }

    @Generated
    public String getConta() {
        return this.conta;
    }

    @Generated
    public String getAgencia() {
        return this.agencia;
    }

    @Generated
    public Long getBanco() {
        return this.banco;
    }

    @Generated
    public String getDescricaoBanco() {
        return this.descricaoBanco;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    @Generated
    public LocalDate getDataCredito() {
        return this.dataCredito;
    }

    @Generated
    public LocalDate getDataLote() {
        return this.dataLote;
    }

    @Generated
    public LocalDate getDataEstorno() {
        return this.dataEstorno;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getUsuarioEstorno() {
        return this.usuarioEstorno;
    }

    @Generated
    public String getMotivoDeducaoEstorno() {
        return this.motivoDeducaoEstorno;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public BigDecimal getValorLancado() {
        return this.valorLancado;
    }

    @Generated
    public BigDecimal getValorDevolvido() {
        return this.valorDevolvido;
    }

    @Generated
    public BigDecimal getValorEstornado() {
        return this.valorEstornado;
    }

    @Generated
    public List<CreditoContribuinteItemDTO> getPorParcelas() {
        return this.porParcelas;
    }

    @Generated
    public List<CreditoContribuinteItemDTO> getPorTributos() {
        return this.porTributos;
    }

    @Generated
    public List<DevolucaoCreditoDTO> getDevolucoes() {
        return this.devolucoes;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setCreditoContribuinte(Long creditoContribuinte) {
        this.creditoContribuinte = creditoContribuinte;
    }

    @Generated
    public void setExercicioLote(Long exercicioLote) {
        this.exercicioLote = exercicioLote;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setSequenciaLote(Long sequenciaLote) {
        this.sequenciaLote = sequenciaLote;
    }

    @Generated
    public void setIdBoleto(Long idBoleto) {
        this.idBoleto = idBoleto;
    }

    @Generated
    public void setBoleto(Long boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setExercicioBoleto(Long exercicioBoleto) {
        this.exercicioBoleto = exercicioBoleto;
    }

    @Generated
    public void setConta(String conta) {
        this.conta = conta;
    }

    @Generated
    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    @Generated
    public void setBanco(Long banco) {
        this.banco = banco;
    }

    @Generated
    public void setDescricaoBanco(String descricaoBanco) {
        this.descricaoBanco = descricaoBanco;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setDataPagamento(LocalDate dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Generated
    public void setDataCredito(LocalDate dataCredito) {
        this.dataCredito = dataCredito;
    }

    @Generated
    public void setDataLote(LocalDate dataLote) {
        this.dataLote = dataLote;
    }

    @Generated
    public void setDataEstorno(LocalDate dataEstorno) {
        this.dataEstorno = dataEstorno;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setUsuarioEstorno(String usuarioEstorno) {
        this.usuarioEstorno = usuarioEstorno;
    }

    @Generated
    public void setMotivoDeducaoEstorno(String motivoDeducaoEstorno) {
        this.motivoDeducaoEstorno = motivoDeducaoEstorno;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorLancado(BigDecimal valorLancado) {
        this.valorLancado = valorLancado;
    }

    @Generated
    public void setValorDevolvido(BigDecimal valorDevolvido) {
        this.valorDevolvido = valorDevolvido;
    }

    @Generated
    public void setValorEstornado(BigDecimal valorEstornado) {
        this.valorEstornado = valorEstornado;
    }

    @Generated
    public void setPorParcelas(List<CreditoContribuinteItemDTO> porParcelas) {
        this.porParcelas = porParcelas;
    }

    @Generated
    public void setPorTributos(List<CreditoContribuinteItemDTO> porTributos) {
        this.porTributos = porTributos;
    }

    @Generated
    public void setDevolucoes(List<DevolucaoCreditoDTO> devolucoes) {
        this.devolucoes = devolucoes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreditoContribuinteDTO)) {
            return false;
        }
        CreditoContribuinteDTO other = (CreditoContribuinteDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$creditoContribuinte = this.getCreditoContribuinte();
        Long other$creditoContribuinte = other.getCreditoContribuinte();
        if (this$creditoContribuinte == null ? other$creditoContribuinte != null : !((Object)this$creditoContribuinte).equals(other$creditoContribuinte)) {
            return false;
        }
        Long this$exercicioLote = this.getExercicioLote();
        Long other$exercicioLote = other.getExercicioLote();
        if (this$exercicioLote == null ? other$exercicioLote != null : !((Object)this$exercicioLote).equals(other$exercicioLote)) {
            return false;
        }
        Long this$lote = this.getLote();
        Long other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !((Object)this$lote).equals(other$lote)) {
            return false;
        }
        Long this$sequenciaLote = this.getSequenciaLote();
        Long other$sequenciaLote = other.getSequenciaLote();
        if (this$sequenciaLote == null ? other$sequenciaLote != null : !((Object)this$sequenciaLote).equals(other$sequenciaLote)) {
            return false;
        }
        Long this$idBoleto = this.getIdBoleto();
        Long other$idBoleto = other.getIdBoleto();
        if (this$idBoleto == null ? other$idBoleto != null : !((Object)this$idBoleto).equals(other$idBoleto)) {
            return false;
        }
        Long this$boleto = this.getBoleto();
        Long other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
            return false;
        }
        Long this$exercicioBoleto = this.getExercicioBoleto();
        Long other$exercicioBoleto = other.getExercicioBoleto();
        if (this$exercicioBoleto == null ? other$exercicioBoleto != null : !((Object)this$exercicioBoleto).equals(other$exercicioBoleto)) {
            return false;
        }
        String this$conta = this.getConta();
        String other$conta = other.getConta();
        if (this$conta == null ? other$conta != null : !this$conta.equals(other$conta)) {
            return false;
        }
        String this$agencia = this.getAgencia();
        String other$agencia = other.getAgencia();
        if (this$agencia == null ? other$agencia != null : !this$agencia.equals(other$agencia)) {
            return false;
        }
        Long this$banco = this.getBanco();
        Long other$banco = other.getBanco();
        if (this$banco == null ? other$banco != null : !((Object)this$banco).equals(other$banco)) {
            return false;
        }
        String this$descricaoBanco = this.getDescricaoBanco();
        String other$descricaoBanco = other.getDescricaoBanco();
        if (this$descricaoBanco == null ? other$descricaoBanco != null : !this$descricaoBanco.equals(other$descricaoBanco)) {
            return false;
        }
        LocalDate this$dataMovimento = this.getDataMovimento();
        LocalDate other$dataMovimento = other.getDataMovimento();
        if (this$dataMovimento == null ? other$dataMovimento != null : !((Object)this$dataMovimento).equals(other$dataMovimento)) {
            return false;
        }
        LocalDate this$dataPagamento = this.getDataPagamento();
        LocalDate other$dataPagamento = other.getDataPagamento();
        if (this$dataPagamento == null ? other$dataPagamento != null : !((Object)this$dataPagamento).equals(other$dataPagamento)) {
            return false;
        }
        LocalDate this$dataCredito = this.getDataCredito();
        LocalDate other$dataCredito = other.getDataCredito();
        if (this$dataCredito == null ? other$dataCredito != null : !((Object)this$dataCredito).equals(other$dataCredito)) {
            return false;
        }
        LocalDate this$dataLote = this.getDataLote();
        LocalDate other$dataLote = other.getDataLote();
        if (this$dataLote == null ? other$dataLote != null : !((Object)this$dataLote).equals(other$dataLote)) {
            return false;
        }
        LocalDate this$dataEstorno = this.getDataEstorno();
        LocalDate other$dataEstorno = other.getDataEstorno();
        if (this$dataEstorno == null ? other$dataEstorno != null : !((Object)this$dataEstorno).equals(other$dataEstorno)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        String this$usuarioEstorno = this.getUsuarioEstorno();
        String other$usuarioEstorno = other.getUsuarioEstorno();
        if (this$usuarioEstorno == null ? other$usuarioEstorno != null : !this$usuarioEstorno.equals(other$usuarioEstorno)) {
            return false;
        }
        String this$motivoDeducaoEstorno = this.getMotivoDeducaoEstorno();
        String other$motivoDeducaoEstorno = other.getMotivoDeducaoEstorno();
        if (this$motivoDeducaoEstorno == null ? other$motivoDeducaoEstorno != null : !this$motivoDeducaoEstorno.equals(other$motivoDeducaoEstorno)) {
            return false;
        }
        BigDecimal this$valorPrincipal = this.getValorPrincipal();
        BigDecimal other$valorPrincipal = other.getValorPrincipal();
        if (this$valorPrincipal == null ? other$valorPrincipal != null : !((Object)this$valorPrincipal).equals(other$valorPrincipal)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorDesconto = this.getValorDesconto();
        BigDecimal other$valorDesconto = other.getValorDesconto();
        if (this$valorDesconto == null ? other$valorDesconto != null : !((Object)this$valorDesconto).equals(other$valorDesconto)) {
            return false;
        }
        BigDecimal this$valorLancado = this.getValorLancado();
        BigDecimal other$valorLancado = other.getValorLancado();
        if (this$valorLancado == null ? other$valorLancado != null : !((Object)this$valorLancado).equals(other$valorLancado)) {
            return false;
        }
        BigDecimal this$valorDevolvido = this.getValorDevolvido();
        BigDecimal other$valorDevolvido = other.getValorDevolvido();
        if (this$valorDevolvido == null ? other$valorDevolvido != null : !((Object)this$valorDevolvido).equals(other$valorDevolvido)) {
            return false;
        }
        BigDecimal this$valorEstornado = this.getValorEstornado();
        BigDecimal other$valorEstornado = other.getValorEstornado();
        if (this$valorEstornado == null ? other$valorEstornado != null : !((Object)this$valorEstornado).equals(other$valorEstornado)) {
            return false;
        }
        List this$porParcelas = this.getPorParcelas();
        List other$porParcelas = other.getPorParcelas();
        if (this$porParcelas == null ? other$porParcelas != null : !((Object)this$porParcelas).equals(other$porParcelas)) {
            return false;
        }
        List this$porTributos = this.getPorTributos();
        List other$porTributos = other.getPorTributos();
        if (this$porTributos == null ? other$porTributos != null : !((Object)this$porTributos).equals(other$porTributos)) {
            return false;
        }
        List this$devolucoes = this.getDevolucoes();
        List other$devolucoes = other.getDevolucoes();
        return !(this$devolucoes == null ? other$devolucoes != null : !((Object)this$devolucoes).equals(other$devolucoes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreditoContribuinteDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $creditoContribuinte = this.getCreditoContribuinte();
        result = result * 59 + ($creditoContribuinte == null ? 43 : ((Object)$creditoContribuinte).hashCode());
        Long $exercicioLote = this.getExercicioLote();
        result = result * 59 + ($exercicioLote == null ? 43 : ((Object)$exercicioLote).hashCode());
        Long $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : ((Object)$lote).hashCode());
        Long $sequenciaLote = this.getSequenciaLote();
        result = result * 59 + ($sequenciaLote == null ? 43 : ((Object)$sequenciaLote).hashCode());
        Long $idBoleto = this.getIdBoleto();
        result = result * 59 + ($idBoleto == null ? 43 : ((Object)$idBoleto).hashCode());
        Long $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
        Long $exercicioBoleto = this.getExercicioBoleto();
        result = result * 59 + ($exercicioBoleto == null ? 43 : ((Object)$exercicioBoleto).hashCode());
        String $conta = this.getConta();
        result = result * 59 + ($conta == null ? 43 : $conta.hashCode());
        String $agencia = this.getAgencia();
        result = result * 59 + ($agencia == null ? 43 : $agencia.hashCode());
        Long $banco = this.getBanco();
        result = result * 59 + ($banco == null ? 43 : ((Object)$banco).hashCode());
        String $descricaoBanco = this.getDescricaoBanco();
        result = result * 59 + ($descricaoBanco == null ? 43 : $descricaoBanco.hashCode());
        LocalDate $dataMovimento = this.getDataMovimento();
        result = result * 59 + ($dataMovimento == null ? 43 : ((Object)$dataMovimento).hashCode());
        LocalDate $dataPagamento = this.getDataPagamento();
        result = result * 59 + ($dataPagamento == null ? 43 : ((Object)$dataPagamento).hashCode());
        LocalDate $dataCredito = this.getDataCredito();
        result = result * 59 + ($dataCredito == null ? 43 : ((Object)$dataCredito).hashCode());
        LocalDate $dataLote = this.getDataLote();
        result = result * 59 + ($dataLote == null ? 43 : ((Object)$dataLote).hashCode());
        LocalDate $dataEstorno = this.getDataEstorno();
        result = result * 59 + ($dataEstorno == null ? 43 : ((Object)$dataEstorno).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        String $usuarioEstorno = this.getUsuarioEstorno();
        result = result * 59 + ($usuarioEstorno == null ? 43 : $usuarioEstorno.hashCode());
        String $motivoDeducaoEstorno = this.getMotivoDeducaoEstorno();
        result = result * 59 + ($motivoDeducaoEstorno == null ? 43 : $motivoDeducaoEstorno.hashCode());
        BigDecimal $valorPrincipal = this.getValorPrincipal();
        result = result * 59 + ($valorPrincipal == null ? 43 : ((Object)$valorPrincipal).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorDesconto = this.getValorDesconto();
        result = result * 59 + ($valorDesconto == null ? 43 : ((Object)$valorDesconto).hashCode());
        BigDecimal $valorLancado = this.getValorLancado();
        result = result * 59 + ($valorLancado == null ? 43 : ((Object)$valorLancado).hashCode());
        BigDecimal $valorDevolvido = this.getValorDevolvido();
        result = result * 59 + ($valorDevolvido == null ? 43 : ((Object)$valorDevolvido).hashCode());
        BigDecimal $valorEstornado = this.getValorEstornado();
        result = result * 59 + ($valorEstornado == null ? 43 : ((Object)$valorEstornado).hashCode());
        List $porParcelas = this.getPorParcelas();
        result = result * 59 + ($porParcelas == null ? 43 : ((Object)$porParcelas).hashCode());
        List $porTributos = this.getPorTributos();
        result = result * 59 + ($porTributos == null ? 43 : ((Object)$porTributos).hashCode());
        List $devolucoes = this.getDevolucoes();
        result = result * 59 + ($devolucoes == null ? 43 : ((Object)$devolucoes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CreditoContribuinteDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", creditoContribuinte=" + this.getCreditoContribuinte() + ", exercicioLote=" + this.getExercicioLote() + ", lote=" + this.getLote() + ", sequenciaLote=" + this.getSequenciaLote() + ", idBoleto=" + this.getIdBoleto() + ", boleto=" + this.getBoleto() + ", exercicioBoleto=" + this.getExercicioBoleto() + ", conta=" + this.getConta() + ", agencia=" + this.getAgencia() + ", banco=" + this.getBanco() + ", descricaoBanco=" + this.getDescricaoBanco() + ", dataMovimento=" + this.getDataMovimento() + ", dataPagamento=" + this.getDataPagamento() + ", dataCredito=" + this.getDataCredito() + ", dataLote=" + this.getDataLote() + ", dataEstorno=" + this.getDataEstorno() + ", usuario=" + this.getUsuario() + ", usuarioEstorno=" + this.getUsuarioEstorno() + ", motivoDeducaoEstorno=" + this.getMotivoDeducaoEstorno() + ", valorPrincipal=" + this.getValorPrincipal() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorDesconto=" + this.getValorDesconto() + ", valorLancado=" + this.getValorLancado() + ", valorDevolvido=" + this.getValorDevolvido() + ", valorEstornado=" + this.getValorEstornado() + ", porParcelas=" + this.getPorParcelas() + ", porTributos=" + this.getPorTributos() + ", devolucoes=" + this.getDevolucoes() + ")";
    }
}

