/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.totem;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.totem.SituacaoPagamentoBoletoTotem;
import br.com.elotech.tributos.dto.totem.PagamentoBoletoTotemRequestDTO;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="tribpagamentoboletototem")
public class PagamentoBoletoTotem
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence
    private Long id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idboleto", referencedColumnName="idkey")
    private Bloqueto boleto;
    private LocalDateTime data;
    @Enumerated(value=EnumType.STRING)
    private SituacaoPagamentoBoletoTotem situacao;
    private String motivoErro;
    @Length(max=250)
    private @Length(max=250) String equipamentoNome;
    @Length(max=250)
    private @Length(max=250) String equipamentoId;
    private BigDecimal valor;
    @Length(max=250)
    private @Length(max=250) String operacao;
    private Long quantidadeParcelas;
    private Long status;
    @Length(max=250)
    private @Length(max=250) String codigoBarras;
    @Length(max=250)
    private @Length(max=250) String numeroSequencialUnico;
    @Length(max=2000)
    private @Length(max=2000) String observacao;
    private String payload;

    public static PagamentoBoletoTotem createSituacaoConfirmado(PagamentoBoletoTotemRequestDTO dto, Bloqueto boleto, JsonNode payload) {
        PagamentoBoletoTotem pagamentoBoletoTotem = PagamentoBoletoTotem.from((PagamentoBoletoTotemRequestDTO)dto, (Bloqueto)boleto, (JsonNode)payload);
        pagamentoBoletoTotem.setSituacao(SituacaoPagamentoBoletoTotem.CONFIRMADO);
        return pagamentoBoletoTotem;
    }

    public static PagamentoBoletoTotem createSituacaoErro(PagamentoBoletoTotemRequestDTO dto, Bloqueto boleto, String motivoErro, JsonNode payload) {
        PagamentoBoletoTotem pagamentoBoletoTotem = PagamentoBoletoTotem.from((PagamentoBoletoTotemRequestDTO)dto, (Bloqueto)boleto, (JsonNode)payload);
        pagamentoBoletoTotem.setSituacao(SituacaoPagamentoBoletoTotem.ERRO);
        pagamentoBoletoTotem.setMotivoErro(motivoErro);
        return pagamentoBoletoTotem;
    }

    private static PagamentoBoletoTotem from(PagamentoBoletoTotemRequestDTO dto, Bloqueto boleto, JsonNode payload) {
        PagamentoBoletoTotem pagamentoBoletoTotem = new PagamentoBoletoTotem();
        pagamentoBoletoTotem.setBoleto(boleto);
        pagamentoBoletoTotem.setData(LocalDateTime.now());
        pagamentoBoletoTotem.setPayload(payload.toString());
        if (Objects.nonNull(dto)) {
            pagamentoBoletoTotem.setEquipamentoNome(dto.getEquipamentoNome());
            pagamentoBoletoTotem.setEquipamentoId(dto.getEquipamentoId());
            pagamentoBoletoTotem.setValor(dto.getValor());
            pagamentoBoletoTotem.setOperacao(dto.getOperacao());
            pagamentoBoletoTotem.setQuantidadeParcelas(dto.getQuantidadeParcelas());
            pagamentoBoletoTotem.setStatus(dto.getStatus());
            pagamentoBoletoTotem.setCodigoBarras(dto.getCodigoBarras());
            pagamentoBoletoTotem.setNumeroSequencialUnico(dto.getNumeroSequencialUnico());
            pagamentoBoletoTotem.setObservacao(dto.getObservacao());
        }
        return pagamentoBoletoTotem;
    }

    @Generated
    public PagamentoBoletoTotem() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Bloqueto getBoleto() {
        return this.boleto;
    }

    @Generated
    public LocalDateTime getData() {
        return this.data;
    }

    @Generated
    public SituacaoPagamentoBoletoTotem getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getMotivoErro() {
        return this.motivoErro;
    }

    @Generated
    public String getEquipamentoNome() {
        return this.equipamentoNome;
    }

    @Generated
    public String getEquipamentoId() {
        return this.equipamentoId;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public String getOperacao() {
        return this.operacao;
    }

    @Generated
    public Long getQuantidadeParcelas() {
        return this.quantidadeParcelas;
    }

    @Generated
    public Long getStatus() {
        return this.status;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public String getNumeroSequencialUnico() {
        return this.numeroSequencialUnico;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getPayload() {
        return this.payload;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setBoleto(Bloqueto boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setData(LocalDateTime data) {
        this.data = data;
    }

    @Generated
    public void setSituacao(SituacaoPagamentoBoletoTotem situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setMotivoErro(String motivoErro) {
        this.motivoErro = motivoErro;
    }

    @Generated
    public void setEquipamentoNome(String equipamentoNome) {
        this.equipamentoNome = equipamentoNome;
    }

    @Generated
    public void setEquipamentoId(String equipamentoId) {
        this.equipamentoId = equipamentoId;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setOperacao(String operacao) {
        this.operacao = operacao;
    }

    @Generated
    public void setQuantidadeParcelas(Long quantidadeParcelas) {
        this.quantidadeParcelas = quantidadeParcelas;
    }

    @Generated
    public void setStatus(Long status) {
        this.status = status;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public void setNumeroSequencialUnico(String numeroSequencialUnico) {
        this.numeroSequencialUnico = numeroSequencialUnico;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setPayload(String payload) {
        this.payload = payload;
    }

    @Generated
    public String toString() {
        return "PagamentoBoletoTotem(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoBoletoTotem)) {
            return false;
        }
        PagamentoBoletoTotem other = (PagamentoBoletoTotem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoBoletoTotem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

