/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.documento.cda;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="triblotecda")
@SQLDelete(sql="UPDATE triblotecda SET excluido = 'S' WHERE id = ? ")
@Where(clause="excluido = 'N'")
public class LoteCda
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="SLOTECDA")
    private Long id;
    @NotNull
    private LocalDate dataSimulacao;
    private LocalDate dataGeracao;
    @Length(max=250)
    @NotNull
    private @Length(max=250) @NotNull String usuario;
    @Length(max=250)
    private @Length(max=250) String usuarioGeracao;
    @NotNull
    private SituacaoLoteCda situacao;
    @NotNull
    @Length(max=4000, message="Tamanho m\u00e1ximo do filtro \u00e9 de 4000 caracteres")
    private @NotNull @Length(max=4000, message="Tamanho m\u00e1ximo do filtro \u00e9 de 4000 caracteres") String filtro;
    @JsonIgnore
    @OneToMany(mappedBy="lote", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<LoteCdaItem> itens = new ArrayList();
    private Boolean excluido = Boolean.FALSE;

    @JsonIgnore
    public void setChildrenId() {
        this.itens.forEach(loteCdaItem -> {
            loteCdaItem.setLote(this);
            loteCdaItem.setChildrenId();
        });
    }

    @JsonIgnore
    public BigDecimal getValorTotal() {
        return this.itens.stream().map(LoteCdaItem::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Generated
    public LoteCda() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataSimulacao() {
        return this.dataSimulacao;
    }

    @Generated
    public LocalDate getDataGeracao() {
        return this.dataGeracao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getUsuarioGeracao() {
        return this.usuarioGeracao;
    }

    @Generated
    public SituacaoLoteCda getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getFiltro() {
        return this.filtro;
    }

    @Generated
    public List<LoteCdaItem> getItens() {
        return this.itens;
    }

    @Generated
    public Boolean getExcluido() {
        return this.excluido;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDataSimulacao(LocalDate dataSimulacao) {
        this.dataSimulacao = dataSimulacao;
    }

    @Generated
    public void setDataGeracao(LocalDate dataGeracao) {
        this.dataGeracao = dataGeracao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setUsuarioGeracao(String usuarioGeracao) {
        this.usuarioGeracao = usuarioGeracao;
    }

    @Generated
    public void setSituacao(SituacaoLoteCda situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setFiltro(String filtro) {
        this.filtro = filtro;
    }

    @Generated
    public void setItens(List<LoteCdaItem> itens) {
        this.itens = itens;
    }

    @Generated
    public void setExcluido(Boolean excluido) {
        this.excluido = excluido;
    }

    @Generated
    public String toString() {
        return "LoteCda(id=" + this.getId() + ", dataSimulacao=" + this.getDataSimulacao() + ", dataGeracao=" + this.getDataGeracao() + ", usuario=" + this.getUsuario() + ", usuarioGeracao=" + this.getUsuarioGeracao() + ", situacao=" + this.getSituacao() + ", filtro=" + this.getFiltro() + ", itens=" + this.getItens() + ", excluido=" + this.getExcluido() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoteCda)) {
            return false;
        }
        LoteCda other = (LoteCda)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoteCda;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

