/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.Formula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="triblivro")
public class Livro
implements EloEntity<LivroId>,
Serializable {
    @EmbeddedId
    private LivroId id;
    private Long numeroRegistroFolha;
    private BigDecimal valorTotalOriginal = BigDecimal.ZERO;
    private BigDecimal valorTotalJuros = BigDecimal.ZERO;
    private BigDecimal valorTotalMulta = BigDecimal.ZERO;
    private BigDecimal valorTotalCorrecao = BigDecimal.ZERO;
    private LocalDate dataInclusao;
    @Length(max=15, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 15 caracteres")
    private @Length(max=15, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 15 caracteres") String usuario;
    private LocalDate dataVencimentoInicial;
    private LocalDate dataVencimentoFinal;
    @Column(name="cadastrogeral")
    @Length(max=100)
    private @Length(max=100) String filtroCadastroGeral;
    @Column(name="guiarecolhimento")
    @Length(max=100)
    private @Length(max=100) String filtroDivida;
    @Column(name="exerciciodebito")
    @Length(max=100)
    private @Length(max=100) String filtroExercicioDebito;
    @Column(name="loteamento")
    @Length(max=50)
    private @Length(max=50) String filtroLoteamento;
    @Column(name="setor")
    @Length(max=50)
    private @Length(max=50) String filtroSetor;
    @Column(name="quadra")
    @Length(max=50)
    private @Length(max=50) String filtroQuadra;
    @Column(name="lote")
    @Length(max=50)
    private @Length(max=50) String filtroLote;
    private Boolean englobaParcelas = Boolean.FALSE;
    private BigDecimal valorTotal = BigDecimal.ZERO;
    private Boolean livroAvulsoAcerto = Boolean.FALSE;
    @Formula(value="( select count(*) from triblivroregistro tlr where tlr.entidade = entidade and tlr.exercicio = exercicio and tlr.livro = livro ) ")
    private Long totalRegistros;
    @Formula(value="( select count(distinct tlr.numeroFolha) from triblivroregistro tlr where tlr.entidade = entidade and tlr.exercicio = exercicio and tlr.livro = livro ) ")
    private Long totalFolhas;
    @ManyToOne
    @JoinColumn(name="IDJOB", referencedColumnName="JOB_EXECUTION_ID")
    private BatchJobExecution batchJobExecution;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="id.livro")
    @JsonIgnore
    private List<LivroRegistro> registros = new ArrayList();

    public static Livro of(LivroId id) {
        Livro livro = new Livro();
        livro.setId(id);
        return livro;
    }

    public void setLivroRegistroId() {
        this.registros.forEach(livroRegistro -> livroRegistro.getId().setLivro(this));
    }

    @Generated
    public Livro() {
    }

    @Generated
    public LivroId getId() {
        return this.id;
    }

    @Generated
    public Long getNumeroRegistroFolha() {
        return this.numeroRegistroFolha;
    }

    @Generated
    public BigDecimal getValorTotalOriginal() {
        return this.valorTotalOriginal;
    }

    @Generated
    public BigDecimal getValorTotalJuros() {
        return this.valorTotalJuros;
    }

    @Generated
    public BigDecimal getValorTotalMulta() {
        return this.valorTotalMulta;
    }

    @Generated
    public BigDecimal getValorTotalCorrecao() {
        return this.valorTotalCorrecao;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public String getFiltroCadastroGeral() {
        return this.filtroCadastroGeral;
    }

    @Generated
    public String getFiltroDivida() {
        return this.filtroDivida;
    }

    @Generated
    public String getFiltroExercicioDebito() {
        return this.filtroExercicioDebito;
    }

    @Generated
    public String getFiltroLoteamento() {
        return this.filtroLoteamento;
    }

    @Generated
    public String getFiltroSetor() {
        return this.filtroSetor;
    }

    @Generated
    public String getFiltroQuadra() {
        return this.filtroQuadra;
    }

    @Generated
    public String getFiltroLote() {
        return this.filtroLote;
    }

    @Generated
    public Boolean getEnglobaParcelas() {
        return this.englobaParcelas;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public Boolean getLivroAvulsoAcerto() {
        return this.livroAvulsoAcerto;
    }

    @Generated
    public Long getTotalRegistros() {
        return this.totalRegistros;
    }

    @Generated
    public Long getTotalFolhas() {
        return this.totalFolhas;
    }

    @Generated
    public BatchJobExecution getBatchJobExecution() {
        return this.batchJobExecution;
    }

    @Generated
    public List<LivroRegistro> getRegistros() {
        return this.registros;
    }

    @Generated
    public void setId(LivroId id) {
        this.id = id;
    }

    @Generated
    public void setNumeroRegistroFolha(Long numeroRegistroFolha) {
        this.numeroRegistroFolha = numeroRegistroFolha;
    }

    @Generated
    public void setValorTotalOriginal(BigDecimal valorTotalOriginal) {
        this.valorTotalOriginal = valorTotalOriginal;
    }

    @Generated
    public void setValorTotalJuros(BigDecimal valorTotalJuros) {
        this.valorTotalJuros = valorTotalJuros;
    }

    @Generated
    public void setValorTotalMulta(BigDecimal valorTotalMulta) {
        this.valorTotalMulta = valorTotalMulta;
    }

    @Generated
    public void setValorTotalCorrecao(BigDecimal valorTotalCorrecao) {
        this.valorTotalCorrecao = valorTotalCorrecao;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public void setFiltroCadastroGeral(String filtroCadastroGeral) {
        this.filtroCadastroGeral = filtroCadastroGeral;
    }

    @Generated
    public void setFiltroDivida(String filtroDivida) {
        this.filtroDivida = filtroDivida;
    }

    @Generated
    public void setFiltroExercicioDebito(String filtroExercicioDebito) {
        this.filtroExercicioDebito = filtroExercicioDebito;
    }

    @Generated
    public void setFiltroLoteamento(String filtroLoteamento) {
        this.filtroLoteamento = filtroLoteamento;
    }

    @Generated
    public void setFiltroSetor(String filtroSetor) {
        this.filtroSetor = filtroSetor;
    }

    @Generated
    public void setFiltroQuadra(String filtroQuadra) {
        this.filtroQuadra = filtroQuadra;
    }

    @Generated
    public void setFiltroLote(String filtroLote) {
        this.filtroLote = filtroLote;
    }

    @Generated
    public void setEnglobaParcelas(Boolean englobaParcelas) {
        this.englobaParcelas = englobaParcelas;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setLivroAvulsoAcerto(Boolean livroAvulsoAcerto) {
        this.livroAvulsoAcerto = livroAvulsoAcerto;
    }

    @Generated
    public void setTotalRegistros(Long totalRegistros) {
        this.totalRegistros = totalRegistros;
    }

    @Generated
    public void setTotalFolhas(Long totalFolhas) {
        this.totalFolhas = totalFolhas;
    }

    @Generated
    public void setBatchJobExecution(BatchJobExecution batchJobExecution) {
        this.batchJobExecution = batchJobExecution;
    }

    @Generated
    public void setRegistros(List<LivroRegistro> registros) {
        this.registros = registros;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Livro)) {
            return false;
        }
        Livro other = (Livro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LivroId this$id = this.getId();
        LivroId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Livro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LivroId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Livro(id=" + this.getId() + ")";
    }
}

