/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.Modelo;
import br.com.elotech.tributos.domain.ParametroItbi;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import liquibase.util.StringUtils;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.validator.constraints.Length;

@Entity(name="TRIBENTIDADETRIBUTACAO")
@Table(name="TRIBENTIDADETRIBUTACAO")
public class EntidadeTributacao
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBENTIDADETRIBUTACAO_ID")
    private Long id;
    @ManyToOne
    @JoinColumn(name="entidade", referencedColumnName="entidade")
    @NotNull
    private Entidade entidade;
    @NotNull
    private Long exercicio;
    @ManyToOne
    @JoinColumn(name="modelobci", referencedColumnName="modelo")
    private Modelo modeloBci;
    @ManyToOne
    @JoinColumn(name="modelobce", referencedColumnName="modelo")
    private Modelo modeloBce;
    private Long modeloCnae;
    private Long modeloBolLogr;
    private Long modeloRural;
    private Long modeloAvulso;
    private Long modeloCondominio;
    private Long modeloConstCivil;
    private Long modeloSetor;
    private Long modeloVistoria;
    private Long tamanhoDistrito;
    private Long tamanhoSetor;
    private Long tamanhoTrecho;
    private Long tamanhoQuadra;
    private Long tamanhoLote;
    private Long tamanhoUnidade;
    private Long tamanhoQuadricula;
    @Length(max=30)
    @Column(name="BASECALCULO_VVT")
    private @Length(max=30) String baseCalculoVVT;
    @Length(max=30)
    @Column(name="BASECALCULO_VVE")
    private @Length(max=30) String baseCalculoVVE;
    @Length(max=30)
    @Column(name="BASECALCULO_VITBI")
    private @Length(max=30) String baseCalculoVITBI;
    @Length(max=30)
    @Column(name="BASECALCULO_VVT_ITBI")
    private @Length(max=30) String baseCalculoVVTITBI;
    @Length(max=30)
    @Column(name="BASECALCULO_VVE_ITBI")
    private @Length(max=30) String baseCalculoVVEITBI;
    @ManyToOne
    @JoinColumn(name="parametroitbi")
    private ParametroItbi parametroITBI;
    private Long paramReparcelamento;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Aberto")
    private Boolean aberto = Boolean.FALSE;
    @Length(max=30)
    @Column(name="INSCRICAOCADASTRALCAMPO01")
    private @Length(max=30) String inscricaoCadastralCampo01;
    @Length(max=30)
    @Column(name="INSCRICAOCADASTRALCAMPO02")
    private @Length(max=30) String inscricaoCadastralCampo02;
    @Length(max=30)
    @Column(name="INSCRICAOCADASTRALCAMPO03")
    private @Length(max=30) String inscricaoCadastralCampo03;
    @Length(max=30)
    @Column(name="INSCRICAOCADASTRALCAMPO04")
    private @Length(max=30) String inscricaoCadastralCampo04;
    @Length(max=30)
    @Column(name="INSCRICAOCADASTRALCAMPO05")
    private @Length(max=30) String inscricaoCadastralCampo05;
    @Length(max=30)
    @Column(name="INSCRICAOCADASTRALCAMPO06")
    private @Length(max=30) String inscricaoCadastralCampo06;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Utiliza Mais de Par\u00e2metro ITBI?")
    private Boolean utilizaMaisDeUmParametroITBI = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Gera C\u00f3digo Notifica\u00e7\u00e3o Sequencial?")
    private Boolean geraCodNotificacaoSequencial = Boolean.FALSE;
    private Long codNotificacaoFiscalInicial;

    public String getMascaraInscricaoCadastral() {
        String mascara = this.getMascaraCampoInscricaoCadastral(this.tamanhoQuadricula).concat(this.getMascaraCampoInscricaoCadastral(this.tamanhoDistrito)).concat(this.getMascaraCampoInscricaoCadastral(this.tamanhoSetor)).concat(this.getMascaraCampoInscricaoCadastral(this.tamanhoQuadra)).concat(this.getMascaraCampoInscricaoCadastral(this.tamanhoLote)).concat(this.getMascaraCampoInscricaoCadastral(this.tamanhoUnidade));
        if (mascara.length() > 0) {
            return mascara.substring(0, mascara.length() - 1);
        }
        return "";
    }

    private String getMascaraCampoInscricaoCadastral(Long tamanhoCampo) {
        if ((Long)ObjectUtils.firstNonNull((Object[])new Long[]{tamanhoCampo, 0L}) > 0L) {
            return StringUtils.repeat((String)"X", (int)tamanhoCampo.intValue()) + "-";
        }
        return "";
    }

    @Generated
    public EntidadeTributacao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Entidade getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Modelo getModeloBci() {
        return this.modeloBci;
    }

    @Generated
    public Modelo getModeloBce() {
        return this.modeloBce;
    }

    @Generated
    public Long getModeloCnae() {
        return this.modeloCnae;
    }

    @Generated
    public Long getModeloBolLogr() {
        return this.modeloBolLogr;
    }

    @Generated
    public Long getModeloRural() {
        return this.modeloRural;
    }

    @Generated
    public Long getModeloAvulso() {
        return this.modeloAvulso;
    }

    @Generated
    public Long getModeloCondominio() {
        return this.modeloCondominio;
    }

    @Generated
    public Long getModeloConstCivil() {
        return this.modeloConstCivil;
    }

    @Generated
    public Long getModeloSetor() {
        return this.modeloSetor;
    }

    @Generated
    public Long getModeloVistoria() {
        return this.modeloVistoria;
    }

    @Generated
    public Long getTamanhoDistrito() {
        return this.tamanhoDistrito;
    }

    @Generated
    public Long getTamanhoSetor() {
        return this.tamanhoSetor;
    }

    @Generated
    public Long getTamanhoTrecho() {
        return this.tamanhoTrecho;
    }

    @Generated
    public Long getTamanhoQuadra() {
        return this.tamanhoQuadra;
    }

    @Generated
    public Long getTamanhoLote() {
        return this.tamanhoLote;
    }

    @Generated
    public Long getTamanhoUnidade() {
        return this.tamanhoUnidade;
    }

    @Generated
    public Long getTamanhoQuadricula() {
        return this.tamanhoQuadricula;
    }

    @Generated
    public String getBaseCalculoVVT() {
        return this.baseCalculoVVT;
    }

    @Generated
    public String getBaseCalculoVVE() {
        return this.baseCalculoVVE;
    }

    @Generated
    public String getBaseCalculoVITBI() {
        return this.baseCalculoVITBI;
    }

    @Generated
    public String getBaseCalculoVVTITBI() {
        return this.baseCalculoVVTITBI;
    }

    @Generated
    public String getBaseCalculoVVEITBI() {
        return this.baseCalculoVVEITBI;
    }

    @Generated
    public ParametroItbi getParametroITBI() {
        return this.parametroITBI;
    }

    @Generated
    public Long getParamReparcelamento() {
        return this.paramReparcelamento;
    }

    @Generated
    public Boolean getAberto() {
        return this.aberto;
    }

    @Generated
    public String getInscricaoCadastralCampo01() {
        return this.inscricaoCadastralCampo01;
    }

    @Generated
    public String getInscricaoCadastralCampo02() {
        return this.inscricaoCadastralCampo02;
    }

    @Generated
    public String getInscricaoCadastralCampo03() {
        return this.inscricaoCadastralCampo03;
    }

    @Generated
    public String getInscricaoCadastralCampo04() {
        return this.inscricaoCadastralCampo04;
    }

    @Generated
    public String getInscricaoCadastralCampo05() {
        return this.inscricaoCadastralCampo05;
    }

    @Generated
    public String getInscricaoCadastralCampo06() {
        return this.inscricaoCadastralCampo06;
    }

    @Generated
    public Boolean getUtilizaMaisDeUmParametroITBI() {
        return this.utilizaMaisDeUmParametroITBI;
    }

    @Generated
    public Boolean getGeraCodNotificacaoSequencial() {
        return this.geraCodNotificacaoSequencial;
    }

    @Generated
    public Long getCodNotificacaoFiscalInicial() {
        return this.codNotificacaoFiscalInicial;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setModeloBci(Modelo modeloBci) {
        this.modeloBci = modeloBci;
    }

    @Generated
    public void setModeloBce(Modelo modeloBce) {
        this.modeloBce = modeloBce;
    }

    @Generated
    public void setModeloCnae(Long modeloCnae) {
        this.modeloCnae = modeloCnae;
    }

    @Generated
    public void setModeloBolLogr(Long modeloBolLogr) {
        this.modeloBolLogr = modeloBolLogr;
    }

    @Generated
    public void setModeloRural(Long modeloRural) {
        this.modeloRural = modeloRural;
    }

    @Generated
    public void setModeloAvulso(Long modeloAvulso) {
        this.modeloAvulso = modeloAvulso;
    }

    @Generated
    public void setModeloCondominio(Long modeloCondominio) {
        this.modeloCondominio = modeloCondominio;
    }

    @Generated
    public void setModeloConstCivil(Long modeloConstCivil) {
        this.modeloConstCivil = modeloConstCivil;
    }

    @Generated
    public void setModeloSetor(Long modeloSetor) {
        this.modeloSetor = modeloSetor;
    }

    @Generated
    public void setModeloVistoria(Long modeloVistoria) {
        this.modeloVistoria = modeloVistoria;
    }

    @Generated
    public void setTamanhoDistrito(Long tamanhoDistrito) {
        this.tamanhoDistrito = tamanhoDistrito;
    }

    @Generated
    public void setTamanhoSetor(Long tamanhoSetor) {
        this.tamanhoSetor = tamanhoSetor;
    }

    @Generated
    public void setTamanhoTrecho(Long tamanhoTrecho) {
        this.tamanhoTrecho = tamanhoTrecho;
    }

    @Generated
    public void setTamanhoQuadra(Long tamanhoQuadra) {
        this.tamanhoQuadra = tamanhoQuadra;
    }

    @Generated
    public void setTamanhoLote(Long tamanhoLote) {
        this.tamanhoLote = tamanhoLote;
    }

    @Generated
    public void setTamanhoUnidade(Long tamanhoUnidade) {
        this.tamanhoUnidade = tamanhoUnidade;
    }

    @Generated
    public void setTamanhoQuadricula(Long tamanhoQuadricula) {
        this.tamanhoQuadricula = tamanhoQuadricula;
    }

    @Generated
    public void setBaseCalculoVVT(String baseCalculoVVT) {
        this.baseCalculoVVT = baseCalculoVVT;
    }

    @Generated
    public void setBaseCalculoVVE(String baseCalculoVVE) {
        this.baseCalculoVVE = baseCalculoVVE;
    }

    @Generated
    public void setBaseCalculoVITBI(String baseCalculoVITBI) {
        this.baseCalculoVITBI = baseCalculoVITBI;
    }

    @Generated
    public void setBaseCalculoVVTITBI(String baseCalculoVVTITBI) {
        this.baseCalculoVVTITBI = baseCalculoVVTITBI;
    }

    @Generated
    public void setBaseCalculoVVEITBI(String baseCalculoVVEITBI) {
        this.baseCalculoVVEITBI = baseCalculoVVEITBI;
    }

    @Generated
    public void setParametroITBI(ParametroItbi parametroITBI) {
        this.parametroITBI = parametroITBI;
    }

    @Generated
    public void setParamReparcelamento(Long paramReparcelamento) {
        this.paramReparcelamento = paramReparcelamento;
    }

    @Generated
    public void setAberto(Boolean aberto) {
        this.aberto = aberto;
    }

    @Generated
    public void setInscricaoCadastralCampo01(String inscricaoCadastralCampo01) {
        this.inscricaoCadastralCampo01 = inscricaoCadastralCampo01;
    }

    @Generated
    public void setInscricaoCadastralCampo02(String inscricaoCadastralCampo02) {
        this.inscricaoCadastralCampo02 = inscricaoCadastralCampo02;
    }

    @Generated
    public void setInscricaoCadastralCampo03(String inscricaoCadastralCampo03) {
        this.inscricaoCadastralCampo03 = inscricaoCadastralCampo03;
    }

    @Generated
    public void setInscricaoCadastralCampo04(String inscricaoCadastralCampo04) {
        this.inscricaoCadastralCampo04 = inscricaoCadastralCampo04;
    }

    @Generated
    public void setInscricaoCadastralCampo05(String inscricaoCadastralCampo05) {
        this.inscricaoCadastralCampo05 = inscricaoCadastralCampo05;
    }

    @Generated
    public void setInscricaoCadastralCampo06(String inscricaoCadastralCampo06) {
        this.inscricaoCadastralCampo06 = inscricaoCadastralCampo06;
    }

    @Generated
    public void setUtilizaMaisDeUmParametroITBI(Boolean utilizaMaisDeUmParametroITBI) {
        this.utilizaMaisDeUmParametroITBI = utilizaMaisDeUmParametroITBI;
    }

    @Generated
    public void setGeraCodNotificacaoSequencial(Boolean geraCodNotificacaoSequencial) {
        this.geraCodNotificacaoSequencial = geraCodNotificacaoSequencial;
    }

    @Generated
    public void setCodNotificacaoFiscalInicial(Long codNotificacaoFiscalInicial) {
        this.codNotificacaoFiscalInicial = codNotificacaoFiscalInicial;
    }

    @Generated
    public String toString() {
        return "EntidadeTributacao(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", modeloBci=" + this.getModeloBci() + ", modeloBce=" + this.getModeloBce() + ", modeloCnae=" + this.getModeloCnae() + ", modeloBolLogr=" + this.getModeloBolLogr() + ", modeloRural=" + this.getModeloRural() + ", modeloAvulso=" + this.getModeloAvulso() + ", modeloCondominio=" + this.getModeloCondominio() + ", modeloConstCivil=" + this.getModeloConstCivil() + ", modeloSetor=" + this.getModeloSetor() + ", modeloVistoria=" + this.getModeloVistoria() + ", tamanhoDistrito=" + this.getTamanhoDistrito() + ", tamanhoSetor=" + this.getTamanhoSetor() + ", tamanhoTrecho=" + this.getTamanhoTrecho() + ", tamanhoQuadra=" + this.getTamanhoQuadra() + ", tamanhoLote=" + this.getTamanhoLote() + ", tamanhoUnidade=" + this.getTamanhoUnidade() + ", tamanhoQuadricula=" + this.getTamanhoQuadricula() + ", baseCalculoVVT=" + this.getBaseCalculoVVT() + ", baseCalculoVVE=" + this.getBaseCalculoVVE() + ", baseCalculoVITBI=" + this.getBaseCalculoVITBI() + ", baseCalculoVVTITBI=" + this.getBaseCalculoVVTITBI() + ", baseCalculoVVEITBI=" + this.getBaseCalculoVVEITBI() + ", parametroITBI=" + this.getParametroITBI() + ", paramReparcelamento=" + this.getParamReparcelamento() + ", aberto=" + this.getAberto() + ", inscricaoCadastralCampo01=" + this.getInscricaoCadastralCampo01() + ", inscricaoCadastralCampo02=" + this.getInscricaoCadastralCampo02() + ", inscricaoCadastralCampo03=" + this.getInscricaoCadastralCampo03() + ", inscricaoCadastralCampo04=" + this.getInscricaoCadastralCampo04() + ", inscricaoCadastralCampo05=" + this.getInscricaoCadastralCampo05() + ", inscricaoCadastralCampo06=" + this.getInscricaoCadastralCampo06() + ", utilizaMaisDeUmParametroITBI=" + this.getUtilizaMaisDeUmParametroITBI() + ", geraCodNotificacaoSequencial=" + this.getGeraCodNotificacaoSequencial() + ", codNotificacaoFiscalInicial=" + this.getCodNotificacaoFiscalInicial() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntidadeTributacao)) {
            return false;
        }
        EntidadeTributacao other = (EntidadeTributacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntidadeTributacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

