/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.BaseCorrecaoMonetaria;
import br.com.elotech.tributos.domain.BaseJurosCorrecao;
import br.com.elotech.tributos.domain.BaseMultaCorrecao;
import br.com.elotech.tributos.domain.EntidadeCorrecaoDivida;
import br.com.elotech.tributos.domain.EntidadeCorrecaoDividaId;
import br.com.elotech.tributos.domain.EntidadeCorrecaoId;
import br.com.elotech.tributos.domain.EntidadeCorrecaoIndice;
import br.com.elotech.tributos.domain.EntidadeCorrecaoIndiceCorrecao;
import br.com.elotech.tributos.domain.EntidadeCorrecaoIndiceEnum;
import br.com.elotech.tributos.domain.EntidadeCorrecaoIndiceId;
import br.com.elotech.tributos.domain.EntidadeCorrecaoIndiceJuros;
import br.com.elotech.tributos.domain.EntidadeCorrecaoIndiceMulta;
import br.com.elotech.tributos.domain.EntidadeCorrecaoMulta;
import br.com.elotech.tributos.domain.EntidadeCorrecaoMultaEspecial;
import br.com.elotech.tributos.domain.EntidadeCorrecaoMultaEspecialId;
import br.com.elotech.tributos.domain.EntidadeCorrecaoMultaId;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.MultaDiasCorrecao;
import br.com.elotech.tributos.domain.acrescimo.TipoJuros;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBENTIDADECORRECAO")
public class EntidadeCorrecao
implements EloEntity<EntidadeCorrecaoId>,
Serializable {
    private static final long serialVersionUID = -5449001472447733017L;
    @EmbeddedId
    private EntidadeCorrecaoId id;
    @NotNull(message="Descri\u00e7\u00e3o obrigat\u00f3ria")
    @Length(max=50, message="Tamanho m\u00e1ximo da descri\u00e7\u00e3o \u00e9 de 50")
    private @NotNull(message="Descri\u00e7\u00e3o obrigat\u00f3ria") @Length(max=50, message="Tamanho m\u00e1ximo da descri\u00e7\u00e3o \u00e9 de 50") String descricao;
    private Boolean multaEspecial = Boolean.FALSE;
    private Boolean principal = Boolean.FALSE;
    private Boolean sobreporMulta = Boolean.FALSE;
    private Boolean arredondaPorPartesNoCalculo = Boolean.FALSE;
    @ManyToOne
    @JoinColumn(name="formacorrecao", referencedColumnName="formacorrecao")
    @IgnoreSizeOf
    private FormaCorrecao formaCorrecao;
    private BigDecimal unidadeFiscal;
    private BigDecimal juroMora;
    @NotNull(message="O tipo de multa n\u00e3o pode ser nulo.")
    private @NotNull(message="O tipo de multa n\u00e3o pode ser nulo.") MultaDiasCorrecao multaDias;
    private TipoJuros mesJuros;
    @NotNull(message="Base corre\u00e7\u00e3o monet\u00e1ria \u00e9 obrigat\u00f3rio para a Entidade corre\u00e7\u00e3o")
    private @NotNull(message="Base corre\u00e7\u00e3o monet\u00e1ria \u00e9 obrigat\u00f3rio para a Entidade corre\u00e7\u00e3o") BaseCorrecaoMonetaria baseCorrecaoMonetaria;
    @NotNull(message="Base juros corre\u00e7\u00e3o \u00e9 obrigat\u00f3rio para a Entidade corre\u00e7\u00e3o")
    private @NotNull(message="Base juros corre\u00e7\u00e3o \u00e9 obrigat\u00f3rio para a Entidade corre\u00e7\u00e3o") BaseJurosCorrecao baseJuros;
    @NotNull(message="Base multa corre\u00e7\u00e3o \u00e9 obrigat\u00f3rio para a Entidade corre\u00e7\u00e3o")
    private @NotNull(message="Base multa corre\u00e7\u00e3o \u00e9 obrigat\u00f3rio para a Entidade corre\u00e7\u00e3o") BaseMultaCorrecao baseMulta;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="id.entidadeCorrecao")
    @IgnoreSizeOf
    private List<EntidadeCorrecaoMulta> correcaoMulta = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="entidadeCorrecao")
    @IgnoreSizeOf
    private List<EntidadeCorrecaoDivida> entidadeCorrecaoDivida = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="id.entidadeCorrecao")
    @IgnoreSizeOf
    private List<EntidadeCorrecaoMultaEspecial> correcaoMultaEspecial = new ArrayList();
    @NotNull(message="Multa nas situa\u00e7\u00f5es \u00e9 obrigat\u00f3rio")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="entidadeCorrecao")
    @IgnoreSizeOf
    private @NotNull(message="Multa nas situa\u00e7\u00f5es \u00e9 obrigat\u00f3rio") EntidadeCorrecaoIndiceMulta entidadeCorrecaoIndiceMulta;
    @NotNull(message="Corre\u00e7\u00f5es nas situa\u00e7\u00f5es \u00e9 obrigat\u00f3rio")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="entidadeCorrecao")
    @IgnoreSizeOf
    private @NotNull(message="Corre\u00e7\u00f5es nas situa\u00e7\u00f5es \u00e9 obrigat\u00f3rio") EntidadeCorrecaoIndiceCorrecao entidadeCorrecaoIndiceCorrecao;
    @NotNull(message="Juros nas situa\u00e7\u00f5es \u00e9 obrigat\u00f3rio")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="entidadeCorrecao")
    @IgnoreSizeOf
    private @NotNull(message="Juros nas situa\u00e7\u00f5es \u00e9 obrigat\u00f3rio") EntidadeCorrecaoIndiceJuros entidadeCorrecaoIndiceJuros;

    @JsonIgnore
    public Long getNextSequenceMulta() {
        return this.correcaoMulta.stream().filter(item -> Objects.nonNull(item.getId()) && Objects.nonNull(item.getId().getMulta())).map(EntidadeCorrecaoMulta::getId).map(EntidadeCorrecaoMultaId::getMulta).max(Long::compare).map(max -> max + 1L).orElse(1L);
    }

    public void setEntidadeCorrecaoMultaEspecialId() {
        this.getCorrecaoMultaEspecial().stream().forEach(correcaoMultaEspecialEntity -> {
            if (Objects.isNull(correcaoMultaEspecialEntity.getId())) {
                EntidadeCorrecaoMultaEspecialId entidadeCorrecaoMultaEspecialId = new EntidadeCorrecaoMultaEspecialId();
                correcaoMultaEspecialEntity.setId(entidadeCorrecaoMultaEspecialId);
            }
            correcaoMultaEspecialEntity.getId().setEntidadeCorrecao(this);
        });
    }

    public void setEntidadeCorrecaoDividaId() {
        this.getEntidadeCorrecaoDivida().stream().forEach(divida -> {
            if (Objects.isNull(divida.getId())) {
                EntidadeCorrecaoDividaId entidadeCorrecaoDividaId = new EntidadeCorrecaoDividaId();
                divida.setId(entidadeCorrecaoDividaId);
            }
            divida.getId().setEntidade(this.getId().getEntidade());
            divida.getId().setExercicio(this.getId().getExercicio());
            divida.getId().setSequencia(this.getId().getSequencia());
            if (Objects.isNull(divida.getId().getDivida()) && Objects.nonNull(divida.getDivida())) {
                divida.getId().setDivida(divida.getDivida().getDivida());
            }
        });
    }

    private void setEntidadeCorrecaoIndice(EntidadeCorrecaoIndice indice, EntidadeCorrecaoIndiceEnum indiceEnum) {
        if (Objects.isNull(indice.getId())) {
            EntidadeCorrecaoIndiceId entidadeCorrecaoIndiceCorrecaoId = new EntidadeCorrecaoIndiceId();
            indice.setId(entidadeCorrecaoIndiceCorrecaoId);
        }
        indice.getId().setIndice(indiceEnum.getValue());
        indice.getId().setEntidade(this.getId().getEntidade());
        indice.getId().setExercicio(this.getId().getExercicio());
        indice.getId().setSequencia(this.getId().getSequencia());
    }

    public void setEntidadeCorrecaoIndiceCorrecaoId() {
        this.setEntidadeCorrecaoIndice((EntidadeCorrecaoIndice)this.entidadeCorrecaoIndiceCorrecao, EntidadeCorrecaoIndiceEnum.CORRECAO);
    }

    public void setEntidadeCorrecaoIndiceJurosId() {
        this.setEntidadeCorrecaoIndice((EntidadeCorrecaoIndice)this.entidadeCorrecaoIndiceJuros, EntidadeCorrecaoIndiceEnum.JUROS);
    }

    public void setEntidadeCorrecaoIndiceMultaId() {
        this.setEntidadeCorrecaoIndice((EntidadeCorrecaoIndice)this.entidadeCorrecaoIndiceMulta, EntidadeCorrecaoIndiceEnum.MULTA);
    }

    public void setCorrecaoMultaId() {
        this.getCorrecaoMulta().stream().forEach(correcaoMultaEntity -> {
            if (Objects.isNull(correcaoMultaEntity.getId())) {
                EntidadeCorrecaoMultaId entidadeCorrecaoMultaId = new EntidadeCorrecaoMultaId();
                correcaoMultaEntity.setId(entidadeCorrecaoMultaId);
            }
            if (Objects.isNull(correcaoMultaEntity.getId().getMulta())) {
                correcaoMultaEntity.getId().setMulta(this.getNextSequenceMulta());
            }
            correcaoMultaEntity.getId().setEntidadeCorrecao(this);
        });
    }

    @Generated
    public String toString() {
        return "EntidadeCorrecao(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", multaEspecial=" + this.getMultaEspecial() + ", principal=" + this.getPrincipal() + ", sobreporMulta=" + this.getSobreporMulta() + ", arredondaPorPartesNoCalculo=" + this.getArredondaPorPartesNoCalculo() + ", formaCorrecao=" + this.getFormaCorrecao() + ", unidadeFiscal=" + this.getUnidadeFiscal() + ", juroMora=" + this.getJuroMora() + ", multaDias=" + this.getMultaDias() + ", mesJuros=" + this.getMesJuros() + ", baseCorrecaoMonetaria=" + this.getBaseCorrecaoMonetaria() + ", baseJuros=" + this.getBaseJuros() + ", baseMulta=" + this.getBaseMulta() + ", correcaoMulta=" + this.getCorrecaoMulta() + ", entidadeCorrecaoDivida=" + this.getEntidadeCorrecaoDivida() + ", correcaoMultaEspecial=" + this.getCorrecaoMultaEspecial() + ", entidadeCorrecaoIndiceMulta=" + this.getEntidadeCorrecaoIndiceMulta() + ", entidadeCorrecaoIndiceCorrecao=" + this.getEntidadeCorrecaoIndiceCorrecao() + ", entidadeCorrecaoIndiceJuros=" + this.getEntidadeCorrecaoIndiceJuros() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntidadeCorrecao)) {
            return false;
        }
        EntidadeCorrecao other = (EntidadeCorrecao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EntidadeCorrecaoId this$id = this.getId();
        EntidadeCorrecaoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntidadeCorrecao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntidadeCorrecaoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public EntidadeCorrecaoId getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getMultaEspecial() {
        return this.multaEspecial;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public Boolean getSobreporMulta() {
        return this.sobreporMulta;
    }

    @Generated
    public Boolean getArredondaPorPartesNoCalculo() {
        return this.arredondaPorPartesNoCalculo;
    }

    @Generated
    public FormaCorrecao getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public BigDecimal getUnidadeFiscal() {
        return this.unidadeFiscal;
    }

    @Generated
    public BigDecimal getJuroMora() {
        return this.juroMora;
    }

    @Generated
    public MultaDiasCorrecao getMultaDias() {
        return this.multaDias;
    }

    @Generated
    public TipoJuros getMesJuros() {
        return this.mesJuros;
    }

    @Generated
    public BaseCorrecaoMonetaria getBaseCorrecaoMonetaria() {
        return this.baseCorrecaoMonetaria;
    }

    @Generated
    public BaseJurosCorrecao getBaseJuros() {
        return this.baseJuros;
    }

    @Generated
    public BaseMultaCorrecao getBaseMulta() {
        return this.baseMulta;
    }

    @Generated
    public List<EntidadeCorrecaoMulta> getCorrecaoMulta() {
        return this.correcaoMulta;
    }

    @Generated
    public List<EntidadeCorrecaoDivida> getEntidadeCorrecaoDivida() {
        return this.entidadeCorrecaoDivida;
    }

    @Generated
    public List<EntidadeCorrecaoMultaEspecial> getCorrecaoMultaEspecial() {
        return this.correcaoMultaEspecial;
    }

    @Generated
    public EntidadeCorrecaoIndiceMulta getEntidadeCorrecaoIndiceMulta() {
        return this.entidadeCorrecaoIndiceMulta;
    }

    @Generated
    public EntidadeCorrecaoIndiceCorrecao getEntidadeCorrecaoIndiceCorrecao() {
        return this.entidadeCorrecaoIndiceCorrecao;
    }

    @Generated
    public EntidadeCorrecaoIndiceJuros getEntidadeCorrecaoIndiceJuros() {
        return this.entidadeCorrecaoIndiceJuros;
    }

    @Generated
    public void setId(EntidadeCorrecaoId id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setMultaEspecial(Boolean multaEspecial) {
        this.multaEspecial = multaEspecial;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setSobreporMulta(Boolean sobreporMulta) {
        this.sobreporMulta = sobreporMulta;
    }

    @Generated
    public void setArredondaPorPartesNoCalculo(Boolean arredondaPorPartesNoCalculo) {
        this.arredondaPorPartesNoCalculo = arredondaPorPartesNoCalculo;
    }

    @Generated
    public void setFormaCorrecao(FormaCorrecao formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setUnidadeFiscal(BigDecimal unidadeFiscal) {
        this.unidadeFiscal = unidadeFiscal;
    }

    @Generated
    public void setJuroMora(BigDecimal juroMora) {
        this.juroMora = juroMora;
    }

    @Generated
    public void setMultaDias(MultaDiasCorrecao multaDias) {
        this.multaDias = multaDias;
    }

    @Generated
    public void setMesJuros(TipoJuros mesJuros) {
        this.mesJuros = mesJuros;
    }

    @Generated
    public void setBaseCorrecaoMonetaria(BaseCorrecaoMonetaria baseCorrecaoMonetaria) {
        this.baseCorrecaoMonetaria = baseCorrecaoMonetaria;
    }

    @Generated
    public void setBaseJuros(BaseJurosCorrecao baseJuros) {
        this.baseJuros = baseJuros;
    }

    @Generated
    public void setBaseMulta(BaseMultaCorrecao baseMulta) {
        this.baseMulta = baseMulta;
    }

    @Generated
    public void setCorrecaoMulta(List<EntidadeCorrecaoMulta> correcaoMulta) {
        this.correcaoMulta = correcaoMulta;
    }

    @Generated
    public void setEntidadeCorrecaoDivida(List<EntidadeCorrecaoDivida> entidadeCorrecaoDivida) {
        this.entidadeCorrecaoDivida = entidadeCorrecaoDivida;
    }

    @Generated
    public void setCorrecaoMultaEspecial(List<EntidadeCorrecaoMultaEspecial> correcaoMultaEspecial) {
        this.correcaoMultaEspecial = correcaoMultaEspecial;
    }

    @Generated
    public void setEntidadeCorrecaoIndiceMulta(EntidadeCorrecaoIndiceMulta entidadeCorrecaoIndiceMulta) {
        this.entidadeCorrecaoIndiceMulta = entidadeCorrecaoIndiceMulta;
    }

    @Generated
    public void setEntidadeCorrecaoIndiceCorrecao(EntidadeCorrecaoIndiceCorrecao entidadeCorrecaoIndiceCorrecao) {
        this.entidadeCorrecaoIndiceCorrecao = entidadeCorrecaoIndiceCorrecao;
    }

    @Generated
    public void setEntidadeCorrecaoIndiceJuros(EntidadeCorrecaoIndiceJuros entidadeCorrecaoIndiceJuros) {
        this.entidadeCorrecaoIndiceJuros = entidadeCorrecaoIndiceJuros;
    }
}

