/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.audit.reader.DiffRevisionIgnoreProperties;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Cidade;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.validator.constraints.Length;

@Entity(name="bairro")
public class Bairro
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence
    private Long id;
    @ManyToOne
    @Caption(value="Cidade")
    @NotNull
    @DiffRevisionIgnoreProperties(value={"id", "pais", "descricaoAbreviada", "codigoNacional", "ativa", "dataCriacao", "programa", "usuario", "idUnico"})
    private Cidade cidade;
    @Caption(value="C\u00f3digo do Bairro")
    @Field(analyze=Analyze.NO)
    @FieldBridge(impl=LongBridge.class)
    private Long bairro;
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o")
    @Fields(value={@Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao")), @Field(name="bairroDescricaoFacet", analyze=Analyze.NO)})
    @Facet(name="bairroDescricaoFacet", forField="bairroDescricaoFacet")
    private @Length(max=100) String descricao;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Correto")
    private Boolean correto = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Inativo")
    private Boolean inativo = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Exclus\u00e3o L\u00f3gica")
    private Boolean exclusaoLogica = Boolean.FALSE;
    @Caption(value="ID \u00danico")
    private Long idunico;

    @Generated
    public Bairro() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Cidade getCidade() {
        return this.cidade;
    }

    @Generated
    public Long getBairro() {
        return this.bairro;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getCorreto() {
        return this.correto;
    }

    @Generated
    public Boolean getInativo() {
        return this.inativo;
    }

    @Generated
    public Boolean getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    @Generated
    public Long getIdunico() {
        return this.idunico;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setBairro(Long bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setCorreto(Boolean correto) {
        this.correto = correto;
    }

    @Generated
    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    @Generated
    public void setExclusaoLogica(Boolean exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    @Generated
    public void setIdunico(Long idunico) {
        this.idunico = idunico;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bairro)) {
            return false;
        }
        Bairro other = (Bairro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bairro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Bairro(id=" + this.getId() + ", bairro=" + this.getBairro() + ")";
    }
}

