/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.AtividadeCnae;
import br.com.elotech.tributos.domain.Cnae;
import br.com.elotech.tributos.domain.HorarioEspecial;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="TRIBATIVIDADE")
public class Atividade
implements EloEntity<Long> {
    @Id
    @Caption(value="Atividade")
    @Column(name="ATIVIDADE")
    @EloSequence(sequenceName="s05Atividade")
    private Long id;
    @Column(length=200)
    @Caption(value="Descri\u00e7\u00e3o")
    private String descricao;
    @ManyToOne
    @JoinColumn(name="CNAE", referencedColumnName="CNAE")
    private Cnae cnae;
    private Long grauRisco;
    @Column(length=2000)
    @Caption(value="Descri\u00e7\u00e3o Detalhada")
    private String descricaoDetalhada;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Agiliza Obras")
    private Boolean agilizaObras = Boolean.TRUE;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Caption(value="Hor\u00e1rios Especiais")
    @JoinTable(name="TRIBCONFIGHORARIOATIVIDADE", joinColumns={@JoinColumn(name="idatividade", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="idhorarioespecial")})
    private List<HorarioEspecial> atividadeHorariosEspeciais = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="atividade")
    private List<AtividadeCnae> atividadeCnaes = new ArrayList();

    @Generated
    public Atividade() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Cnae getCnae() {
        return this.cnae;
    }

    @Generated
    public Long getGrauRisco() {
        return this.grauRisco;
    }

    @Generated
    public String getDescricaoDetalhada() {
        return this.descricaoDetalhada;
    }

    @Generated
    public Boolean getAgilizaObras() {
        return this.agilizaObras;
    }

    @Generated
    public List<HorarioEspecial> getAtividadeHorariosEspeciais() {
        return this.atividadeHorariosEspeciais;
    }

    @Generated
    public List<AtividadeCnae> getAtividadeCnaes() {
        return this.atividadeCnaes;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setCnae(Cnae cnae) {
        this.cnae = cnae;
    }

    @Generated
    public void setGrauRisco(Long grauRisco) {
        this.grauRisco = grauRisco;
    }

    @Generated
    public void setDescricaoDetalhada(String descricaoDetalhada) {
        this.descricaoDetalhada = descricaoDetalhada;
    }

    @Generated
    public void setAgilizaObras(Boolean agilizaObras) {
        this.agilizaObras = agilizaObras;
    }

    @Generated
    public void setAtividadeHorariosEspeciais(List<HorarioEspecial> atividadeHorariosEspeciais) {
        this.atividadeHorariosEspeciais = atividadeHorariosEspeciais;
    }

    @Generated
    public void setAtividadeCnaes(List<AtividadeCnae> atividadeCnaes) {
        this.atividadeCnaes = atividadeCnaes;
    }

    @Generated
    public String toString() {
        return "Atividade(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", cnae=" + this.getCnae() + ", grauRisco=" + this.getGrauRisco() + ", descricaoDetalhada=" + this.getDescricaoDetalhada() + ", agilizaObras=" + this.getAgilizaObras() + ", atividadeHorariosEspeciais=" + this.getAtividadeHorariosEspeciais() + ", atividadeCnaes=" + this.getAtividadeCnaes() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Atividade)) {
            return false;
        }
        Atividade other = (Atividade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Atividade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

