/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import br.com.elotech.tributos.ws.soap.client.ManutencaoBancariaCEFClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

@Configuration
public class SoapClientConfiguration {
    private static String CONTEXT_PATH_MARSHALLER = "br.com.elotech.soap.webservice.caixa.manutencao";
    private static String URI_MANUTENCAO_BANCARIA_CEF = "https://barramento.caixa.gov.br/sibar/ManutencaoCobrancaBancaria/Boleto/Externo";

    @Bean
    public Jaxb2Marshaller marshaller() {
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setContextPath(CONTEXT_PATH_MARSHALLER);
        return marshaller;
    }

    @Bean
    public ManutencaoBancariaCEFClient cefClient(Jaxb2Marshaller marshaller) {
        ManutencaoBancariaCEFClient client = new ManutencaoBancariaCEFClient();
        client.setDefaultUri(URI_MANUTENCAO_BANCARIA_CEF);
        client.setMarshaller((Marshaller)marshaller);
        client.setUnmarshaller((Unmarshaller)marshaller);
        return client;
    }
}

