/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import java.io.IOException;
import org.keycloak.admin.client.Keycloak;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class GatewayRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private final Keycloak keycloak;

    public GatewayRestTemplateInterceptor(Keycloak keycloak) {
        this.keycloak = keycloak;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String token = this.keycloak.tokenManager().grantToken().getToken();
        request.getHeaders().set("authorization", "Bearer " + token);
        return execution.execute(request, body);
    }
}

