/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.domain.TipoCampoDinamico;
import br.com.elotech.tributos.calculo.dto.CampoDinamicoScriptDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.domain.calculo.CalculoConfigBase;
import br.com.elotech.tributos.domain.calculo.CalculoScriptBase;
import br.com.elotech.tributos.domain.calculo.TipoCalculoScript;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculoParser {
    private static final String TEMPLATE_FUNCAO_CALCULO = "br/com/elotech/tributos/calculo/template-funcao-calculo.txt";
    private static final String TEMPLATE_FUNCAO_CALCULO_DEBUG = "br/com/elotech/tributos/calculo/template-funcao-calculo-debug.txt";
    private static final String REGEX_IDENTIFICADOR_LINHA = "#(\\w+)";
    private static final String REGEX_ATRIBUTO_CADASTRO = "((cadastro|segmento|testada|testadagenerica|servico|atividade|cnae)\\.(?!get|campo)(\\w+))";
    private static final String REGEX_IDENTIFICADOR_E = "(?<![\\w])e(?![\\w])|(?<![\\w])E(?![\\w])";
    private static final String REGEX_IDENTIFICADOR_OU = "(?<![\\w])ou(?![\\w])|(?<![\\w])OU(?![\\w])";
    private static final String REGEX_IDENTIFICADOR_DIFERENTE = "^(.*)(?<![>,<])<>(.*)$";
    private static final String REGEX_IDENTIFICADOR_IGUAL = "^(.*)(?<![>,<])=(.*)$";
    private static final String REGEX_COMPARADOR_STRING_IGUAL_DIREITA = String.format("%s\\s*=\\s*(\".*\")", "((cadastro|segmento|testada|testadagenerica|servico|atividade|cnae)\\.(?!get|campo)(\\w+))");
    private static final String REGEX_COMPARADOR_STRING_IGUAL_ESQUERDA = String.format("(\".*\")\\s*=\\s*(%s)", "((cadastro|segmento|testada|testadagenerica|servico|atividade|cnae)\\.(?!get|campo)(\\w+))");
    private static final String REGEX_COMPARADOR_STRING_DIFERENTE_DIREITA = String.format("%s\\s*<>\\s*(\".*\")", "((cadastro|segmento|testada|testadagenerica|servico|atividade|cnae)\\.(?!get|campo)(\\w+))");
    private static final String REGEX_COMPARADOR_STRING_DIFERENTE_ESQUERDA = String.format("(\".*\")\\s*<>\\s*(%s)", "((cadastro|segmento|testada|testadagenerica|servico|atividade|cnae)\\.(?!get|campo)(\\w+))");
    private static final String REGEX_CAMPO_DINAMICO = "(campo|campointeiro|campotexto|valoralternativa)\\((cadastro|segmento|testada),\\s*\"(?<=\\\")(.*?)(?=\\\")\"";

    private CalculoParser() {
    }

    public static Set<CampoDinamicoScriptDTO> extractCamposDinamicos(List<? extends CalculoConfigBase> configs) {
        HashSet<CampoDinamicoScriptDTO> camposDinamicos = new HashSet<CampoDinamicoScriptDTO>();
        Pattern pattern = Pattern.compile("(campo|campointeiro|campotexto|valoralternativa)\\((cadastro|segmento|testada),\\s*\"(?<=\\\")(.*?)(?=\\\")\"");
        configs.forEach(calculoConfig -> calculoConfig.getScript().forEach(scriptLinha -> {
            String expressao = scriptLinha.getExpressao();
            if (TipoCalculoScript.CONDICIONAL.equals((Object)scriptLinha.getTipo())) {
                expressao = String.format("%s %s %s", scriptLinha.getExpressao(), scriptLinha.getExpressaoVerdadeira(), scriptLinha.getExpressaoFalsa());
            }
            Matcher matcher = pattern.matcher(expressao);
            while (matcher.find()) {
                camposDinamicos.add(CampoDinamicoScriptDTO.from((TipoCampoDinamico)TipoCampoDinamico.fromValue((String)matcher.group(2)), (String)matcher.group(3)));
            }
        }));
        return camposDinamicos;
    }

    private static String condicaoObrigatoria(CalculoScriptBase linha) {
        if (Boolean.TRUE.equals(linha.getObrigatorio())) {
            return " if (Objects.isNull(retorno) || retorno == 0.0) { throw new CalculoException(\"Linha identificador \u00e9 obrigat\u00f3ria.\"); } ".replace("identificador", linha.getIdentificador());
        }
        return "";
    }

    public static String parseLinhaDebugMode(List<String> identificadores, CalculoScriptBase linha) {
        String identificadoresLinhasAnteriores = CalculoParser.extractIdentificadores(identificadores, (CalculoScriptBase)linha);
        return CalculoParser.parseLinhas(Collections.singletonList(linha), (String)linha.getIdentificador(), null, null, (String)identificadoresLinhasAnteriores, null);
    }

    public static String parseLinhas(List<? extends CalculoScriptBase> script, String identificadorResultado, String identificadorBaseCalculo, String identificadorCondicao, String identificadorDebug, String identificadorAliquota) {
        String templateFuncao = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/calculo/template-funcao-calculo.txt");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("import br.com.elotech.tributos.calculo.exception.CalculoException;%n", new Object[0])).append(String.format("import java.util.Objects;%n", new Object[0]));
        AtomicBoolean existeIdentificadorBase = new AtomicBoolean(false);
        AtomicBoolean existeIdentificadorResultado = new AtomicBoolean(false);
        AtomicBoolean existeIdentificadorAliquota = new AtomicBoolean(false);
        script.forEach(linha -> {
            if (linha.getIdentificador().equals(identificadorBaseCalculo)) {
                existeIdentificadorBase.set(true);
            }
            if (linha.getIdentificador().equals(identificadorResultado)) {
                existeIdentificadorResultado.set(true);
            }
            if (linha.getIdentificador().equals(identificadorAliquota)) {
                existeIdentificadorAliquota.set(true);
            }
            stringBuilder.append(templateFuncao.replace("$debug$", identificadorDebug).replace("$identificador$", linha.getIdentificador()).replace("$expressao$", CalculoParser.parse((CalculoScriptBase)linha)).replace("$obrigatorio$", CalculoParser.condicaoObrigatoria((CalculoScriptBase)linha))).append(String.format("; %n", new Object[0]));
        });
        if (StringUtils.isNotBlank((String)identificadorBaseCalculo) && !existeIdentificadorBase.get()) {
            throw new CalculoException("Identificador da base n\u00e3o configurada no c\u00e1lculo, verifique o script configurado.");
        }
        if (!existeIdentificadorResultado.get()) {
            throw new CalculoException("Identificador do resultado n\u00e3o configurado no c\u00e1lculo, verifique o script configurado.");
        }
        if (StringUtils.isNotBlank((String)identificadorAliquota) && !existeIdentificadorAliquota.get()) {
            throw new CalculoException("Identificador da al\u00edquota n\u00e3o configurado no c\u00e1lculo, verifique o script configurado.");
        }
        if (StringUtils.isNotBlank((String)identificadorCondicao)) {
            stringBuilder.append(String.format(" if (falso(%s())) {return;} %n", identificadorCondicao));
        }
        stringBuilder.append(String.format("%s(); %n", identificadorResultado));
        if (StringUtils.isNotBlank((String)identificadorBaseCalculo)) {
            stringBuilder.append(String.format("%s(); %n", identificadorBaseCalculo));
        }
        if (StringUtils.isNotBlank((String)identificadorAliquota)) {
            stringBuilder.append(String.format("%s(); %n", identificadorAliquota));
        }
        return stringBuilder.toString();
    }

    private static String extractIdentificadores(List<String> identificadores, CalculoScriptBase linha) {
        String templateFuncao = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/calculo/template-funcao-calculo-debug.txt");
        Pattern pattern = Pattern.compile("#(\\w+)");
        Matcher matcher = pattern.matcher(String.format("%s %s %s", linha.getExpressao(), linha.getExpressaoVerdadeira(), linha.getExpressaoFalsa()));
        HashSet<String> identificadoresLinhasAnteriores = new HashSet<String>();
        while (matcher.find()) {
            if (!identificadores.stream().anyMatch(identificador -> identificador.equals(matcher.group(1)))) continue;
            identificadoresLinhasAnteriores.add(matcher.group(1));
        }
        return identificadoresLinhasAnteriores.stream().map(identificador -> templateFuncao.replace("$identificador$", (CharSequence)identificador)).collect(Collectors.joining(""));
    }

    private static String parse(CalculoScriptBase scriptLinha) {
        return TipoCalculoScript.CONDICIONAL.equals((Object)scriptLinha.getTipo()) ? CalculoParser.parseExpressaoCondicional((String)scriptLinha.getExpressao(), (String)scriptLinha.getExpressaoVerdadeira(), (String)scriptLinha.getExpressaoFalsa()) : CalculoParser.parseExpressao((String)scriptLinha.getExpressao());
    }

    private static String parseIdentificadorIgualDiferente(String text) {
        return text.replaceAll("^(.*)(?<![>,<])=(.*)$", " compareObjectEquals($1,$2) ").replaceAll("^(.*)(?<![>,<])<>(.*)$", " compareObjectNotEquals($1,$2) ");
    }

    private static String parseExpressao(String expressao) {
        String expressaoAlterada = expressao.replaceAll("#(\\w+)", "$1()").replaceAll(REGEX_COMPARADOR_STRING_IGUAL_DIREITA, "comparestringequals($1, $4)").replaceAll(REGEX_COMPARADOR_STRING_IGUAL_ESQUERDA, "comparestringequals($1, $2)").replaceAll(REGEX_COMPARADOR_STRING_DIFERENTE_DIREITA, "comparestringnotequals($1, $4)").replaceAll(REGEX_COMPARADOR_STRING_DIFERENTE_ESQUERDA, "comparestringnotequals($1, $2)").replaceAll("((cadastro|segmento|testada|testadagenerica|servico|atividade|cnae)\\.(?!get|campo)(\\w+))", "getcampocadastro($0, \"$0\")").replaceAll("(?<![\\w])e(?![\\w])|(?<![\\w])E(?![\\w])", "&&").replaceAll("(?<![\\w])ou(?![\\w])|(?<![\\w])OU(?![\\w])", "||");
        if (expressaoAlterada.contains("&&")) {
            String[] expressaoAnd;
            for (String e : expressaoAnd = expressaoAlterada.split("&&")) {
                expressaoAlterada = expressaoAlterada.trim().replace(e.trim(), CalculoParser.parseIdentificadorIgualDiferente((String)e));
            }
        }
        if (expressaoAlterada.contains("||")) {
            String[] expressaoOr;
            for (String e : expressaoOr = expressaoAlterada.split("\\|\\|")) {
                expressaoAlterada = expressaoAlterada.trim().replace(e.trim(), CalculoParser.parseIdentificadorIgualDiferente((String)e));
            }
        }
        expressaoAlterada = CalculoParser.parseIdentificadorIgualDiferente((String)expressaoAlterada);
        return expressaoAlterada;
    }

    private static String parseExpressaoCondicional(String condicional, String expressaoVerdadeira, String expressaoFalsa) {
        return String.format("%s ? %s : %s", CalculoParser.parseExpressao((String)condicional), CalculoParser.parseExpressao((String)expressaoVerdadeira), CalculoParser.parseExpressao((String)expressaoFalsa));
    }
}

