/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.domain.TabelaValor;
import br.com.elotech.tributos.calculo.domain.TabelaValorCelula;
import br.com.elotech.tributos.calculo.dto.TabelaValorParametroDTO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class TabelaValorDTO {
    private Long id;
    @NotBlank
    @Length(max=250)
    @Pattern(regexp="^([a-z_])([a-z0-9_])*$", message="Nome da tabela deve conter apenas caracteres alfanum\u00e9ricos min\u00fasculos e underline, sem espa\u00e7os. A primeira letra deve ser uma letra ou underline.")
    private @NotBlank @Length(max=250) @Pattern(regexp="^([a-z_])([a-z0-9_])*$", message="Nome da tabela deve conter apenas caracteres alfanum\u00e9ricos min\u00fasculos e underline, sem espa\u00e7os. A primeira letra deve ser uma letra ou underline.") String nome;
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicio;
    @NotBlank
    @Length(max=250)
    private @NotBlank @Length(max=250) String descricao;
    @Valid
    private List<TabelaValorParametroDTO> parametros = new ArrayList();
    @NotEmpty
    private List<Map<String, String>> linhas = new ArrayList();

    public static TabelaValorDTO of(TabelaValor tabelaValor) {
        TabelaValorDTO tabelaValorDTO = new TabelaValorDTO();
        tabelaValorDTO.setId(tabelaValor.getId());
        tabelaValorDTO.setNome(tabelaValor.getNome());
        tabelaValorDTO.setDescricao(tabelaValor.getDescricao());
        tabelaValorDTO.setEntidade(tabelaValor.getEntidade());
        tabelaValorDTO.setExercicio(tabelaValor.getExercicio());
        tabelaValorDTO.setParametros(tabelaValor.getColunas().stream().filter(coluna -> !coluna.getDescricao().equalsIgnoreCase("resultado")).map(TabelaValorParametroDTO::of).collect(Collectors.toList()));
        tabelaValor.getColunas().stream().flatMap(coluna -> coluna.getCelulas().stream()).filter(celula -> StringUtils.isNotBlank((CharSequence)celula.getValor())).sorted(Comparator.comparing(TabelaValorCelula::getLinha)).collect(Collectors.groupingBy(TabelaValorCelula::getLinha)).values().forEach(celulasDaLinha -> {
            Map<String, String> linhas = celulasDaLinha.stream().collect(Collectors.toMap(celula -> celula.getColuna().getReferenciaColuna(), TabelaValorCelula::getValor));
            tabelaValorDTO.getLinhas().add(linhas);
        });
        return tabelaValorDTO;
    }

    @Generated
    public TabelaValorDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public List<TabelaValorParametroDTO> getParametros() {
        return this.parametros;
    }

    @Generated
    public List<Map<String, String>> getLinhas() {
        return this.linhas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setParametros(List<TabelaValorParametroDTO> parametros) {
        this.parametros = parametros;
    }

    @Generated
    public void setLinhas(List<Map<String, String>> linhas) {
        this.linhas = linhas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabelaValorDTO)) {
            return false;
        }
        TabelaValorDTO other = (TabelaValorDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        List this$parametros = this.getParametros();
        List other$parametros = other.getParametros();
        if (this$parametros == null ? other$parametros != null : !((Object)this$parametros).equals(other$parametros)) {
            return false;
        }
        List this$linhas = this.getLinhas();
        List other$linhas = other.getLinhas();
        return !(this$linhas == null ? other$linhas != null : !((Object)this$linhas).equals(other$linhas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TabelaValorDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        List $parametros = this.getParametros();
        result = result * 59 + ($parametros == null ? 43 : ((Object)$parametros).hashCode());
        List $linhas = this.getLinhas();
        result = result * 59 + ($linhas == null ? 43 : ((Object)$linhas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TabelaValorDTO(id=" + this.getId() + ", nome=" + this.getNome() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", descricao=" + this.getDescricao() + ", parametros=" + this.getParametros() + ", linhas=" + this.getLinhas() + ")";
    }
}

