/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.lancamentocredito;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoConsultaDTO;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LancamentoCreditoImplantacaoSaldoBatchReader
extends JdbcCursorItemReader<LancamentoCreditoConsultaDTO> {
    public LancamentoCreditoImplantacaoSaldoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) throws Exception {
        Long entidade = (Long)jobParameters.get("entidade");
        Long exercicio = (Long)jobParameters.get("exercicio");
        Long idControle = (Long)jobParameters.get("idControle");
        this.setFetchSize(1000);
        this.setName("simamLancamentoCreditoImplantacaoSaldoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(LancamentoCreditoConsultaDTO.class));
        this.setSql("SELECT CASE WHEN (tcrt.tributavel = 'S') THEN 1 ELSE 2 END AS idTipoNaturezaCredito,  trt.classificacaoreceitatipo AS idTipoCredito,  2 AS idTipoOperacaoCredito,  tcii.datalancamento AS dtlancamento,  tcii.valor AS vlLancamento,  tdpr.iddebitoparcelareceita,  td.entidade,  tdpr.exercicio,  tgr.idkey as idDivida,  tdpr.guiarecolhimento AS divida,  td.formacorrecao, ato.idtce as cdControleLeiAto FROM tcecontroleimplantacao tci JOIN tcecontroleimplantacaoitem tcii   ON tci.id = tcii.idcontrole JOIN tribdebitoparcelareceita tdpr   ON tcii.iddebitoparcelareceita = tdpr.iddebitoparcelareceita JOIN tribdebitoparcela tdp   ON tdp.entidade = tdpr.entidade  AND tdp.exercicio = tdpr.exercicio  AND tdp.tipocadastro = tdpr.tipocadastro  AND tdp.cadastrogeral = tdpr.cadastrogeral  AND tdp.guiarecolhimento = tdpr.guiarecolhimento  AND tdp.subdivida = tdpr.subdivida  AND tdp.parcela = tdpr.parcela JOIN tribdebito td   ON td.entidade = tdp.entidade  AND td.exercicio = tdp.exercicio  AND td.tipocadastro = tdp.tipocadastro  AND td.cadastrogeral = tdp.cadastrogeral  AND td.guiarecolhimento = tdp.guiarecolhimento  AND td.subdivida = tdp.subdivida JOIN tribguiarecolhimento tgr   ON td.entidade = tgr.entidade  AND td.exercicio = tgr.exercicio  AND td.guiarecolhimento = tgr.guiarecolhimento JOIN tribreceita tr   ON tr.receita = tdpr.receita " + String.format(" AND tr.entidade = %d  AND tr.exercicio = %d ", entidade, exercicio) + "JOIN tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita JOIN tribclassificacaoreceitatipo tcrt   ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo LEFT JOIN cgato ato on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato " + String.format("WHERE tci.id = %d   AND trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)   AND tdp.situacaolegal = 0   AND td.entidade = %d   AND NOT EXISTS (SELECT 1 FROM tcedebitolanccredito tdlc                   WHERE tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita) ", idControle, entidade) + "ORDER BY dtlancamento ASC, idTipoNaturezaCredito ASC, idTipoCredito ASC, exercicio ASC, divida ASC");
    }
}

