/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.inscricaodividaativa;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class InscricaoDividaAtivaImplantacaoSaldoJobListener
extends JobExecutionListenerSupport {
    private static final String ENTIDADE = "entidade";
    private static final String EXERCICIO = "exercicio";
    private static final String CONTROLE = "idControle";
    private static final String JOB_TYPE = "jobType";
    private static final String INSCRICAO_DIVIDA_ATIVA_IMPLANTACAO_SALDO = JobType.SIMAM_INSCRICAO_DIVIDA_ATIVA_IMPLANTACAO_SALDO.getTipo();
    private final NotificacaoClient notificacaoClient;

    public InscricaoDividaAtivaImplantacaoSaldoJobListener(NotificacaoClient notificacaoClient) {
        this.notificacaoClient = notificacaoClient;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long entidade = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ENTIDADE));
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        Long idControle = Objects.requireNonNull(jobExecution.getJobParameters().getLong(CONTROLE));
        Notificacao notificacao = Notificacao.builder().title("SIM-AM - Inscri\u00e7\u00e3o de d\u00edvida ativa (Implanta\u00e7\u00e3o de saldo) iniciado").text(String.format("Iniciada a gera\u00e7\u00e3o de dados de Inscri\u00e7\u00e3o de d\u00edvida ativa (Implanta\u00e7\u00e3o de saldo) do exerc\u00edcio %d.", exercicio)).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)INSCRICAO_DIVIDA_ATIVA_IMPLANTACAO_SALDO).metadata(ENTIDADE, (Object)entidade).metadata(EXERCICIO, (Object)exercicio).metadata(CONTROLE, (Object)idControle).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long entidade = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ENTIDADE));
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        Long idControle = Objects.requireNonNull(jobExecution.getJobParameters().getLong(CONTROLE));
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)INSCRICAO_DIVIDA_ATIVA_IMPLANTACAO_SALDO).metadata(ENTIDADE, (Object)entidade).metadata(EXERCICIO, (Object)exercicio).metadata(CONTROLE, (Object)idControle);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao.title("SIM-AM - Inscri\u00e7\u00e3o de D\u00edvida Ativa (Implanta\u00e7\u00e3o de saldo) finalizado com sucesso").text(String.format("Os dados referentes \u00e0 Inscri\u00e7\u00e3o de D\u00edvida Ativa (Implanta\u00e7\u00e3o de saldo) do exerc\u00edcio %d foram gerados com sucesso.", exercicio));
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.title("Erro na gera\u00e7\u00e3o de dados do SIM-AM - Inscri\u00e7\u00e3o de D\u00edvida Ativa").text("N\u00e3o foi poss\u00edvel gerar os dados.").metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }
}

