/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.inscricaodividaativa;

import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.simam.DebitoInscricaoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DebitoInscricaoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.InscricaoCreditoDividaAtiva;
import br.com.elotech.tributos.domain.simam.InscricaoCreditoDividaAtivaConsultaDTO;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributo;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.dto.TipoNaturezaCredito;
import br.com.elotech.tributos.dto.TipoOperacaoCredito;
import br.com.elotech.tributos.repository.simam.InscricaoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class InscricaoDividaAtivaBatchWriter
implements ItemWriter<InscricaoCreditoDividaAtivaConsultaDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InscricaoDividaAtivaBatchWriter.class);
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository;
    private Long nrAnoDivida;
    private LocalDate dataInicial;
    private LocalDate dataFinal;
    private boolean isImplantacaoSaldo;
    private AtomicLong ultimoNrDivida = new AtomicLong(0L);

    public InscricaoDividaAtivaBatchWriter(EntityManager entityManager, InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository) {
        this.entityManager = entityManager;
        this.inscricaoCreditoDividaAtivaRepository = inscricaoCreditoDividaAtivaRepository;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.isImplantacaoSaldo = "true".equals(stepExecution.getJobExecution().getJobParameters().getString("implantacaoSaldo", "false"));
        if (this.isImplantacaoSaldo) {
            this.nrAnoDivida = stepExecution.getJobExecution().getJobParameters().getLong("exercicio");
        } else {
            this.dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
            this.dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
            this.nrAnoDivida = this.dataInicial.getYear();
        }
        this.ultimoNrDivida.set(this.inscricaoCreditoDividaAtivaRepository.findNextNrDividaByExercicio(this.nrAnoDivida));
    }

    @AfterWrite
    public void afterWrite(List<? extends LancamentoCreditoTributo> items) {
        LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends InscricaoCreditoDividaAtivaConsultaDTO> items) {
        HashMap cargaExistente = new HashMap();
        if (this.isImplantacaoSaldo) {
            this.inscricaoCreditoDividaAtivaRepository.getCargaExistente(this.dataInicial, this.dataFinal).forEach(itemCargaExistente -> cargaExistente.put(itemCargaExistente.buildChaveAgrupamento(), itemCargaExistente.getInscricao()));
        }
        items.forEach(item -> {
            InscricaoCreditoDividaAtiva inscricaoCreditoDividaAtiva = this.getOrCreateInscricaoDividaAtiva(cargaExistente, item);
            DebitoInscricaoDividaAtiva debitoInscricaoDividaAtiva = new DebitoInscricaoDividaAtiva();
            debitoInscricaoDividaAtiva.setId(new DebitoInscricaoDividaAtivaId());
            debitoInscricaoDividaAtiva.setInscricaoCredito(inscricaoCreditoDividaAtiva);
            debitoInscricaoDividaAtiva.setDebitoOrigem((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaTributoOrigem()));
            debitoInscricaoDividaAtiva.setDebitoDestino((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaTributoDestino()));
            debitoInscricaoDividaAtiva.setValor(item.getValorCorrigido());
            inscricaoCreditoDividaAtiva.addDebito(debitoInscricaoDividaAtiva);
        });
        this.inscricaoCreditoDividaAtivaRepository.saveAll(cargaExistente.values());
        this.entityManager.flush();
    }

    private InscricaoCreditoDividaAtiva getOrCreateInscricaoDividaAtiva(Map<String, InscricaoCreditoDividaAtiva> cargaExistente, InscricaoCreditoDividaAtivaConsultaDTO item) {
        return cargaExistente.compute(item.buildChaveAgrupamento(), (chave, inscricaoJaExistente) -> {
            if (Objects.nonNull(inscricaoJaExistente)) {
                return inscricaoJaExistente;
            }
            InscricaoCreditoDividaAtiva newValue = new InscricaoCreditoDividaAtiva();
            newValue.setTipoNaturezaCredito(TipoNaturezaCredito.fromValue((Long)item.getIdTipoNaturezaCredito()));
            newValue.setTipoCredito(ClassificacaoTipoTributo.fromValue((Integer)item.getIdTipoCredito().intValue()));
            newValue.setTipoOperacaoCredito(TipoOperacaoCredito.fromValue((Long)item.getIdTipoOperacaoCredito()));
            newValue.setDataInscricao(item.getDtInscricao());
            newValue.setNrAnoDivida(this.nrAnoDivida);
            newValue.setNrDivida(Long.valueOf(this.ultimoNrDivida.getAndIncrement()));
            LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - gerando novo registro -> ({}/{})", (Object)newValue.getNrDivida(), (Object)newValue.getNrAnoDivida());
            return newValue;
        });
    }
}

