/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.inscricaodividaativa;

import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.MudancaMonetaria;
import br.com.elotech.tributos.domain.simam.InscricaoCreditoDividaAtivaConsultaDTO;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.MudancaMonetariaService;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoUtils;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class InscricaoDividaAtivaBatchProcessor
implements ItemProcessor<InscricaoCreditoDividaAtivaConsultaDTO, InscricaoCreditoDividaAtivaConsultaDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InscricaoDividaAtivaBatchProcessor.class);
    private Map<Long, FormaCorrecao> formasDeCorrecao = new ConcurrentHashMap();
    private Map<Long, FormaCorrecao> outrasFormasDeCorrecao = new ConcurrentHashMap();
    private List<MudancaMonetaria> mudancasMonetarias = new ArrayList();
    private LocalDate dataReferencia = null;
    private Boolean isImplantacaoSaldo;
    private final FormaCorrecaoService formaCorrecaoService;
    private final ObjectMapper objectMapper;
    private final MudancaMonetariaService mudancaMonetariaService;

    public InscricaoDividaAtivaBatchProcessor(FormaCorrecaoService formaCorrecaoService, ObjectMapper objectMapper, MudancaMonetariaService mudancaMonetariaService) {
        this.formaCorrecaoService = formaCorrecaoService;
        this.objectMapper = objectMapper;
        this.mudancaMonetariaService = mudancaMonetariaService;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - Iniciando gera\u00e7\u00e3o de dados");
        this.dataReferencia = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataReferencia")));
        this.isImplantacaoSaldo = "true".equals(stepExecution.getJobExecution().getJobParameters().getString("implantacaoSaldo", "false"));
        this.outrasFormasDeCorrecao = new ConcurrentHashMap();
        this.formasDeCorrecao = new ConcurrentHashMap();
        if (this.isImplantacaoSaldo.booleanValue()) {
            Long exercicio = stepExecution.getJobExecution().getJobParameters().getLong("exercicio");
            Long idControle = stepExecution.getJobExecution().getJobParameters().getLong("idControle");
            LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - Implanta\u00e7\u00e3o Saldo - Iniciando gera\u00e7\u00e3o de dados - idControle: {}, exercicio: {} ", (Object)idControle, (Object)exercicio);
            return;
        }
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {} ", (Object)dataInicial, (Object)dataFinal);
        LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - carregando lista das formas de corre\u00e7\u00f5es existentes");
        this.formaCorrecaoService.findAll(Pageable.unpaged()).getContent().stream().map(FormaCorrecao::getId).forEach(idFormaCorrecao -> this.formasDeCorrecao.put(idFormaCorrecao, this.formaCorrecaoService.findOne(idFormaCorrecao)));
        this.mudancasMonetarias = this.mudancaMonetariaService.findByRsql(Optional.empty());
    }

    public InscricaoCreditoDividaAtivaConsultaDTO process(InscricaoCreditoDividaAtivaConsultaDTO item) {
        if (this.isImplantacaoSaldo.booleanValue()) {
            item.setValorCorrigido(item.getVlInscricao());
            return item;
        }
        FormaCorrecao formaCorrecao = this.resolveFormaCorrecao(item);
        BigDecimal valorCorrigido = CalculoCorrecaoUtils.converteMoedaOuAplicaMudanca((BigDecimal)item.getVlInscricao(), (LocalDate)item.getDtInscricao(), (LocalDate)this.dataReferencia, (FormaCorrecao)formaCorrecao, (List)this.mudancasMonetarias);
        item.setValorCorrigido(valorCorrigido);
        return item;
    }

    private FormaCorrecao resolveFormaCorrecao(InscricaoCreditoDividaAtivaConsultaDTO item) {
        if (Objects.nonNull(item.getFormaCorrecao())) {
            return (FormaCorrecao)this.formasDeCorrecao.get(item.getFormaCorrecao());
        }
        return Optional.ofNullable((FormaCorrecao)this.outrasFormasDeCorrecao.get(item.getIdDivida())).orElseGet(() -> {
            FormaCorrecao formaCorrecaoPadrao = this.formaCorrecaoService.getFormaCorrecaoPadrao(item.getIdDivida(), item.getEntidade(), item.getExercicio());
            this.outrasFormasDeCorrecao.put(item.getIdDivida(), formaCorrecaoPadrao);
            return formaCorrecaoPadrao;
        });
    }

    @OnProcessError
    public void onProcessError(InscricaoCreditoDividaAtivaConsultaDTO item, Exception e) throws JsonProcessingException {
        LOGGER.error("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }
}

