/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.implantacaosaldo;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.domain.simam.ImplantacaoSaldoConsultaDTO;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImplantacaoSaldoBatchReader
extends JdbcCursorItemReader<ImplantacaoSaldoConsultaDTO> {
    public ImplantacaoSaldoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        Long entidade = (Long)jobParameters.get("entidade");
        Long exercicio = (Long)jobParameters.get("exercicio");
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataFinal")));
        String dataReferencia = DateUtils.localDateToString((LocalDate)dataFinal);
        this.setFetchSize(1000);
        this.setName("implantacaoSaldoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(ImplantacaoSaldoConsultaDTO.class));
        this.setSql("SELECT tdpr.iddebitoparcelareceita, trt.classificacaoreceitatipo as classificacaoreceita," + String.format(" CASE   WHEN (tdp.situacaolegal in (1,2)) AND (tdp.datadividaativa > '%s') THEN 0", dataReferencia) + "   WHEN tdp.situacaolegal in (1,2) THEN 1   ELSE tdp.situacaolegal END AS situacaolegal, tdp.situacaodebito, CASE   WHEN td.datacontabilizacao IS NOT NULL THEN td.datacontabilizacao   ELSE td.datainclusao  END AS datalancamento, tdp.datasituacao, tdp.datadividaativa, td.entidade, tdpr.exercicio, tgr.idkey AS idDivida, tdpr.guiarecolhimento AS divida, td.formacorrecao, tdpr.valor AS valor FROM tribdebitoparcelareceita tdpr JOIN tribdebitoparcela tdp  ON tdp.entidade = tdpr.entidade AND tdp.exercicio = tdpr.exercicio AND tdp.tipocadastro = tdpr.tipocadastro AND tdp.cadastrogeral = tdpr.cadastrogeral AND tdp.guiarecolhimento = tdpr.guiarecolhimento AND tdp.subdivida = tdpr.subdivida AND tdp.parcela = tdpr.parcela JOIN tribdebito td ON td.entidade = tdp.entidade AND td.exercicio = tdp.exercicio AND td.tipocadastro = tdp.tipocadastro AND td.cadastrogeral = tdp.cadastrogeral AND td.guiarecolhimento = tdp.guiarecolhimento AND td.subdivida = tdp.subdivida JOIN tribguiarecolhimento tgr ON td.entidade = tgr.entidade AND td.exercicio = tgr.exercicio AND td.guiarecolhimento = tgr.guiarecolhimento JOIN tribreceita tr ON tr.receita = tdpr.receita" + String.format(" AND tr.exercicio = %d", exercicio) + " AND tr.entidade = tdpr.entidade JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita JOIN tribclassificacaoreceitatipo tcrt ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo JOIN tribsituacaoparcela tsp ON tdp.situacaodebito = tsp.situacaoparcela JOIN tribtiposituacaoparcela ttsp ON tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela " + String.format(" WHERE tdpr.entidade = %d AND tdpr.valor > 0 AND ((td.datainclusao <= '%s' AND td.datacontabilizacao is null) OR (td.datacontabilizacao <= '%s')) AND td.constituido = 'S'  AND tgr.constituinopagamento = 'N'  AND ((ttsp.tipo = 'A') or (ttsp.tipo <> 'A' AND tdp.datasituacao > '%s' ))", entidade, dataReferencia, dataReferencia, dataReferencia) + " ORDER BY tdp.datalancamento DESC");
    }
}

