/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.atualizacaocredito;

import br.com.elotech.tributos.domain.simam.AtualizacaoCreditoParcelamento;
import br.com.elotech.tributos.domain.simam.AtualizacaoCreditoParcelamentoConsultaDTO;
import br.com.elotech.tributos.domain.simam.AtualizacaoCreditoParcelamentoId;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCredito;
import br.com.elotech.tributos.domain.simam.TipoAtualizacaoCredito;
import br.com.elotech.tributos.dto.ClassificacaoTributo;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoParcelamentoDTO;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoParcelamentoNrCreditoDTO;
import br.com.elotech.tributos.enums.TipoAtualizacaoCreditoSimAm;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoCreditoParcelamentoRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoCreditoRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class AtualizacaoCreditoParcelamentoBatchProcessor
implements ItemProcessor<AtualizacaoCreditoParcelamentoConsultaDTO, TipoAtualizacaoCredito> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoCreditoParcelamentoBatchProcessor.class);
    private static final String ATUALIZACAO_CREDITO = "SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - ";
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final AtualizacaoMonetariaCreditoRepository atualizacaoMonetariaCreditoRepository;
    private final AtualizacaoCreditoParcelamentoRepository atualizacaoCreditoParcelamentoRepository;
    private final AtualizacaoCreditoRepository atualizacaoCreditoRepository;
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final AtomicLong nrAtualizacao = new AtomicLong(0L);
    private Long nrAnoAtualizacao;
    private Long entidade;
    private Long exercicio;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        log.info("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados do parcelamento");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        this.entidade = Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        this.exercicio = Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getLong("exercicio"));
        this.nrAnoAtualizacao = dataInicial.getYear();
        log.info("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - load da carga existente");
        this.atualizacaoCreditoRepository.getCargaExistente(dataInicial, dataFinal, this.entidade, this.exercicio).forEach(item -> this.cargaExistente.put(item.getChave(), item.getIdTceAtualizaMoneCred()));
        log.info("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - atualizando \u00faltimo nrAtualizacao");
        this.nrAtualizacao.set(this.atualizacaoMonetariaCreditoRepository.getNrAtualizacao(this.nrAnoAtualizacao));
        log.info("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados do parcelamento - data inicial: {}, data final: {}, entidade: {} ", new Object[]{dataInicial, dataFinal, this.entidade});
    }

    public TipoAtualizacaoCredito process(AtualizacaoCreditoParcelamentoConsultaDTO item) throws Exception {
        BigDecimal valorLancamento = BigDecimal.ZERO;
        List parcelamentoReceita = this.atualizacaoCreditoParcelamentoRepository.loadParcelamento(item.getReceita(), item.getIdParcelamento(), this.entidade, this.exercicio);
        for (AtualizacaoCreditoParcelamentoDTO parcelamento : parcelamentoReceita) {
            List nrCreditos = this.atualizacaoCreditoParcelamentoRepository.loadParcelamentoNrCredito(ClassificacaoTributo.fromValue((String)parcelamento.getClassificacao()), parcelamento.getIdParcelamento(), parcelamento.getReceitaPrincipal(), parcelamento.getReceita(), this.entidade, this.exercicio);
            for (int i = 0; i < nrCreditos.size(); ++i) {
                boolean hasNext;
                AtualizacaoCreditoParcelamentoNrCreditoDTO credito = (AtualizacaoCreditoParcelamentoNrCreditoDTO)nrCreditos.get(i);
                String chave = String.format("%d-%d-%d-%s-%d", parcelamento.getIdTipoAtualizacaoCredito(), credito.getNrCredito(), credito.getNrAnoCredito(), parcelamento.getDtAtualizacao().toString(), credito.getCdControleLeiAto());
                BigDecimal valor = Optional.of(credito).map(AtualizacaoCreditoParcelamentoNrCreditoDTO::getPercentual).filter(percentual -> percentual.signum() > 0).map(percentual -> percentual.divide(new BigDecimal(100.0)).multiply(parcelamento.getVlAtualizacao())).orElse(BigDecimal.ZERO);
                valorLancamento = valorLancamento.add(valor);
                boolean bl = hasNext = i + 1 < nrCreditos.size();
                if (hasNext && Optional.ofNullable(credito.getIdParcelamento()).orElse(0L).equals(((AtualizacaoCreditoParcelamentoNrCreditoDTO)nrCreditos.get(i + 1)).getIdParcelamento()) && Optional.ofNullable(credito.getNrCredito()).orElse(0L).equals(((AtualizacaoCreditoParcelamentoNrCreditoDTO)nrCreditos.get(i + 1)).getNrCredito()) && Optional.ofNullable(credito.getNrAnoCredito()).orElse(0L).equals(((AtualizacaoCreditoParcelamentoNrCreditoDTO)nrCreditos.get(i + 1)).getNrAnoCredito()) && Optional.ofNullable(credito.getCdControleLeiAto()).orElse(0L).equals(((AtualizacaoCreditoParcelamentoNrCreditoDTO)nrCreditos.get(i + 1)).getCdControleLeiAto()) && Optional.ofNullable(parcelamento.getIdTipoAtualizacaoCredito()).orElse(0L).equals(parcelamento.getIdTipoAtualizacaoCredito())) continue;
                BigDecimal finalValorLancamento = valorLancamento;
                Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
                    if (Objects.nonNull(v)) {
                        return v;
                    }
                    Long nextVal = this.sequenceGeneratorRepository.getNextVal("S05IDTCEATUALIZAMONECRED");
                    AtualizacaoMonetariaCredito atualizacaoMonetaria = new AtualizacaoMonetariaCredito();
                    atualizacaoMonetaria.setId(nextVal);
                    atualizacaoMonetaria.setNrAtualizacao(Long.valueOf(this.nrAtualizacao.getAndIncrement()));
                    atualizacaoMonetaria.setNrAnoAtualizacao(this.nrAnoAtualizacao);
                    atualizacaoMonetaria.setTipoAtualizacaoCredito(TipoAtualizacaoCreditoSimAm.fromValue((Long)parcelamento.getIdTipoAtualizacaoCredito()));
                    atualizacaoMonetaria.setDtAtualizacao(parcelamento.getDtAtualizacao());
                    atualizacaoMonetaria.setVlAtualizacao(finalValorLancamento);
                    log.info("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - gerando novo registro do parcelamento -> {} ({}/{})", new Object[]{nextVal, this.nrAtualizacao, this.nrAnoAtualizacao});
                    this.atualizacaoCreditoRepository.saveAndFlush((Object)atualizacaoMonetaria);
                    return nextVal;
                });
                AtualizacaoCreditoParcelamentoId id = new AtualizacaoCreditoParcelamentoId();
                id.setIdParcelamento(item.getIdParcelamento());
                id.setAtualizacaoMonetariaCredito(finalId);
                id.setIdDebitoParcelaReceita(credito.getIdDebitoParcelaReceita());
                AtualizacaoCreditoParcelamento parcelamentoDA = new AtualizacaoCreditoParcelamento();
                parcelamentoDA.setAtualizacaoCreditoParcelamentoId(id);
                parcelamentoDA.setValor(valorLancamento);
                this.atualizacaoCreditoParcelamentoRepository.save((Object)parcelamentoDA);
                valorLancamento = BigDecimal.ZERO;
            }
        }
        return null;
    }

    @OnProcessError
    public void onProcessError(Object item, Exception e) throws Exception {
        log.error("SIM-AM - Atualiza\u00e7\u00e3o Cr\u00e9dito - erro: {}\n{})", (Object)e.getMessage(), (Object)ObjectMapperSingleton.getObjectMapper().writeValueAsString(item));
    }

    @Generated
    public AtualizacaoCreditoParcelamentoBatchProcessor(SequenceGeneratorRepository sequenceGeneratorRepository, AtualizacaoMonetariaCreditoRepository atualizacaoMonetariaCreditoRepository, AtualizacaoCreditoParcelamentoRepository atualizacaoCreditoParcelamentoRepository, AtualizacaoCreditoRepository atualizacaoCreditoRepository) {
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.atualizacaoMonetariaCreditoRepository = atualizacaoMonetariaCreditoRepository;
        this.atualizacaoCreditoParcelamentoRepository = atualizacaoCreditoParcelamentoRepository;
        this.atualizacaoCreditoRepository = atualizacaoCreditoRepository;
    }
}

