/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.createlivrodividaativa;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.dto.dividaativa.FiltroGeraLivroDTO;
import br.com.elotech.tributos.exception.JobParameterSerializationException;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.GeraLivroDividaAtivaBatchService;
import br.com.elotech.tributos.service.LivroService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
@Transactional
public class LivroDividaAtivaJobListener
extends JobExecutionListenerSupport {
    private final Logger log = LoggerFactory.getLogger(LivroDividaAtivaJobListener.class);
    private static final String LIVRO = "livro";
    private final NotificacaoClient notificacaoClient;
    private final GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService;
    private final ObjectMapper objectMapper;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;
    private final LivroService livroService;
    private final FormaPagamentoService formaPagamentoService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;

    public LivroDividaAtivaJobListener(NotificacaoClient notificacaoClient, GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService, ObjectMapper objectMapper, ParametroEntidadeExercicioService parametroEntidadeExercicioService, LivroService livroService, FormaPagamentoService formaPagamentoService, ValidaDataMovimentacaoService validaDataMovimentacaoService) {
        this.notificacaoClient = notificacaoClient;
        this.geraLivroDividaAtivaBatchService = geraLivroDividaAtivaBatchService;
        this.objectMapper = objectMapper;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
        this.livroService = livroService;
        this.formaPagamentoService = formaPagamentoService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        FiltroGeraLivroDTO filtro = this.getFiltroFromJobParameters(jobExecution.getJobParameters());
        Boolean inscricaoPorParcela = "P".equals(jobExecution.getJobParameters().getString("inscricaoPorParcela"));
        Boolean englobaDebitos = this.getEnglobaDebito(inscricaoPorParcela);
        Livro livro = this.getLivroFromParameters(jobExecution.getJobParameters());
        Date dataInscricaoParametro = jobExecution.getJobParameters().getDate("dataInscricao");
        if (Objects.isNull(dataInscricaoParametro)) {
            this.log.warn("Job execution {} sem data de inscri\u00e7\u00e3o no parametro, utilizando data atual.", (Object)jobExecution.getId());
            dataInscricaoParametro = new Date();
        }
        LocalDate dataInscricao = DateUtils.dateToLocalDate((Date)dataInscricaoParametro);
        this.validaDataMovimentacaoService.validaMesEDia(livro.getId().getEntidade(), dataInscricao);
        livro.setBatchJobExecution(BatchJobExecution.of((JobExecution)jobExecution));
        this.livroService.save((EloEntity)livro, null);
        FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        jobExecution.getExecutionContext().put(LIVRO, (Object)livro);
        jobExecution.getExecutionContext().put("filtro", (Object)filtro);
        jobExecution.getExecutionContext().put("inscricaoPorParcela", (Object)inscricaoPorParcela);
        jobExecution.getExecutionContext().put("englobaDebitos", (Object)englobaDebitos);
        jobExecution.getExecutionContext().put("formaPagamentoPadrao", (Object)formaPagamentoPadrao);
        jobExecution.getExecutionContext().put("dataInscricao", (Object)dataInscricao);
        this.enviaNotificacaoInicio(jobExecution);
    }

    private Livro getLivroFromParameters(JobParameters jobParameters) {
        try {
            LivroId livroId = (LivroId)this.objectMapper.readValue(jobParameters.getString("livroId"), LivroId.class);
            return (Livro)this.livroService.findOne((Serializable)livroId);
        }
        catch (IOException e) {
            throw new JobParameterSerializationException("Erro ao deserializar o livro no parametro do job", (Throwable)e);
        }
    }

    private FiltroGeraLivroDTO getFiltroFromJobParameters(JobParameters jobParameters) {
        try {
            return (FiltroGeraLivroDTO)this.objectMapper.readValue(jobParameters.getString("filtro"), FiltroGeraLivroDTO.class);
        }
        catch (IOException e) {
            throw new JobParameterSerializationException("Erro ao deserializar o filtro no parametro do job", (Throwable)e);
        }
    }

    private Boolean getEnglobaDebito(Boolean inscricaoPorParcela) {
        Boolean englobaDebitos = this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO, ParametroEntidadeExercicioEnum.ENGLOBA_DEBITO_DIVIDA_ATIVA).map(ParametroEntidadeExercicio::getValor).map("S"::equals).orElse(Boolean.FALSE);
        if (inscricaoPorParcela.booleanValue() && englobaDebitos.booleanValue()) {
            throw new EloValidationException("Par\u00e2metro Tipo Inscri\u00e7\u00e3o D\u00edvida Ativa configurado errado. N\u00e3o \u00e9 poss\u00edvel englobar parcelas com tipo inscri\u00e7\u00e3o por parcela.");
        }
        return englobaDebitos;
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        this.enviaNotificacaoFim(jobExecution);
    }

    private void enviaNotificacaoInicio(JobExecution jobExecution) {
        Notificacao notificacao = Notificacao.builder().text("Gera\u00e7\u00e3o do livro de d\u00edvida ativa iniciado").title("Foi iniciada a gera\u00e7\u00e3o do l\u00edvro de divida ativa").time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    private void enviaNotificacaoFim(JobExecution jobExecution) {
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            Livro livro = (Livro)jobExecution.getExecutionContext().get(LIVRO);
            this.geraLivroDividaAtivaBatchService.atualizarValorPai(livro);
            Long entidade = livro.getId().getEntidade();
            Long exercicio = livro.getId().getExercicio();
            Long numeroLivro = livro.getId().getLivro();
            notificacao.text("Gera\u00e7\u00e3o do livro de d\u00edvida ativa finalizada com sucesso").title(String.format("A gera\u00e7\u00e3o do livro %d/%d foi finalizada com sucesso.", numeroLivro, exercicio)).metadata("jobType", (Object)JobType.CREATE_LIVRO_DIVIDA_ATIVA.getTipo()).metadata("entidade", (Object)entidade).metadata("exercicio", (Object)exercicio).metadata(LIVRO, (Object)numeroLivro);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Erro na gera\u00e7\u00e3o do livro de d\u00edvida ativa").title("N\u00e3o foi poss\u00edvel realizar a gera\u00e7\u00e3o do livro.").metadata("jobType", (Object)JobType.CREATE_LIVRO_DIVIDA_ATIVA.getTipo()).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }
}

