/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.consultadebito;

import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.domain.ConsultaDebitoItem;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.dto.DebitoConstituidoItemDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.service.ConsultaDebitoBatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ConsultaDebitoBatchProcessor
implements ItemProcessor<Long, List<ConsultaDebitoItem>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsultaDebitoBatchProcessor.class);
    private StepExecution stepExecution;
    private final ConsultaDebitoBatchService consultaDebitoBatchService;
    private final DebitoRepository debitoRepository;

    public ConsultaDebitoBatchProcessor(ConsultaDebitoBatchService consultaDebitoBatchService, DebitoRepository debitoRepository) {
        this.consultaDebitoBatchService = consultaDebitoBatchService;
        this.debitoRepository = debitoRepository;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public List<ConsultaDebitoItem> process(Long idDebito) {
        LOGGER.info("Read Count: {}. idDebito: {}. Job ID {}.", new Object[]{this.stepExecution.getReadCount(), idDebito, this.stepExecution.getJobExecution().getId()});
        ExecutionContext executionContext = this.stepExecution.getJobExecution().getExecutionContext();
        ConsultaDebito consultaDebito = (ConsultaDebito)executionContext.get("consultaDebito");
        LOGGER.info("Debito {}", (Object)Objects.requireNonNull(consultaDebito).getId());
        FiltroConsultaDebitoDTO filtro = (FiltroConsultaDebitoDTO)executionContext.get("filtro");
        FormaPagamento formaPagamento = (FormaPagamento)executionContext.get("formaPagamentoPadrao");
        List debitosConstituidos = this.debitoRepository.findAllDebitoConstituidoById(filtro, idDebito);
        if (Boolean.TRUE.equals(filtro.getCalcularAcrescimos())) {
            this.consultaDebitoBatchService.calcularAcrescimos(debitosConstituidos, formaPagamento, filtro.getDataReferencia());
            LOGGER.info("Read Count: {}. {} registros calculado acr\u00e9scimo.", (Object)this.stepExecution.getReadCount(), (Object)debitosConstituidos.size());
        }
        ArrayList<ConsultaDebitoItem> consultaDebitoItems = new ArrayList<ConsultaDebitoItem>();
        debitosConstituidos.forEach(debito -> consultaDebitoItems.add(ConsultaDebitoItem.of((DebitoConstituidoItemDTO)debito, (ConsultaDebito)consultaDebito)));
        return consultaDebitoItems;
    }
}

