/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.audit;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.audit.TributosRevision;
import br.com.elotech.tributos.security.SecurityUtils;
import java.util.Date;
import java.util.UUID;
import lombok.Generated;
import org.hibernate.envers.RevisionListener;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TributosRevisionListener
implements RevisionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TributosRevisionListener.class);

    public void newRevision(Object revisionEntity) {
        TributosRevision revision = (TributosRevision)revisionEntity;
        revision.setRevisionDate(new Date());
        revision.setApplication("Tributos");
        revision.setRemoteIpAddress(SecurityUtils.getRequestIP());
        try {
            AccessToken token = SecurityUtils.getAccessToken();
            revision.setUserId(UUID.fromString(token.getSubject()));
            revision.setUserName(token.getName());
        }
        catch (EloValidationException ex) {
            log.warn("N\u00e3o foi poss\u00edvel extrair os dados do usu\u00e1rio da requisi\u00e7\u00e3o.");
            revision.setUserName("ANONIMO");
        }
    }
}

