SELECT x.entidade,
       x.datamovimentacao,
       x.tributo,
       x.descricaotributo,
       x.classificacaotributo,
       x.situacaolegal,
       x.tipooperacaodeducao,
       CASE
         WHEN x.tipodeducao = 6 THEN 'ESTORNO_DACAO_PAGAMENTO' ELSE 'ESTORNO_CANCELAMENTO'
       END as tipomovimento,
       sum(x.valor) as valor
from (
select td.entidade,
       tcdi.dataestorno as datamovimentacao,
       td.iddebito,
       tr.id as idtributo,
       tdpr.receita as tributo,
       tr.descricao as descricaotributo,
       tr.classificacao as classificacaotributo,
       tcdi.situacaolegal,
       ttd.tipodeducao,
       cast (null as numeric(2)) as tipooperacaodeducao,
       sum(coalesce(tcdi.valor,0)) as valor
from tribcancelamentodebito tcd
left outer join tribcancelamentodebitoitem tcdi
 on tcd.entidade = tcdi.entidade
and tcd.exercicio = tcdi.exercicio
and tcd.idcancelamento = tcdi.idcancelamento
left outer join tribdebitoparcelareceita tdpr
 on tcdi.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
left outer join tribreceita tr
on tdpr.entidade = tr.entidade
and tdpr.exercicio = tr.exercicio
and tdpr.receita = tr.receita
left outer join tribdebito td
 on tdpr.entidade = td.entidade
and tdpr.exercicio = td.exercicio
and tdpr.tipocadastro = td.tipocadastro
and tdpr.cadastrogeral = td.cadastrogeral
and tdpr.guiarecolhimento = td.guiarecolhimento
and tdpr.subdivida = td.subdivida
left outer join tribmotivodesconto tmd
 on tcd.motivocancelamento = tmd.motivodesconto
left outer join tribtipodeducao ttd
 on tmd.tipodeducao = ttd.tipodeducao
where tcdi.dataestorno in (:datasMovimento)
and tcdi.estornado = 'S'
and td.constituido = 'S'
and not exists (select 1 from tribestornoparcelamentodebito tepd
                left outer join tribestornoparcelamento tep
                on tepd.idestornoparcelamento = tep.idestornoparcelamento
                where tepd.iddebitoorigem = td.iddebito)
group by td.entidade,
       tcdi.dataestorno,
       td.iddebito,
       tr.id,
       tdpr.receita,
       tr.descricao,
       tr.classificacao,
       tcdi.situacaolegal,
       ttd.tipodeducao
) x
group by x.entidade,
       x.datamovimentacao,
       x.tributo,
       x.descricaotributo,
       x.classificacaotributo,
       x.situacaolegal,
       x.tipooperacaodeducao,
       CASE
         WHEN x.tipodeducao = 6 THEN 'ESTORNO_DACAO_PAGAMENTO' ELSE 'ESTORNO_CANCELAMENTO'
       END